/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.rest.HttpRequestRetryStepParameters;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.index.repository.base.AccountBasedRepositoryConnectorBase;
import com.teamscale.index.repository.tfs.TfsRepositoryConnection;
import com.teamscale.index.repository.tfs.TfsRepositoryInfoIndex;
import com.teamscale.index.repository.tfs.UniformPathCasingIndex;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;

public class TfsRepositoryConnector
extends AccountBasedRepositoryConnectorBase<TfsRepositoryConnection> {
    static final String BRANCH_LOOKUP_PATH_PARAMETER = "branch-lookup-path";
    static final String NON_BRANCHED_MODE_PARAMETER = "non-branched-mode";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private UniformPathCasingIndex uniformPathCasingIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private TfsRepositoryInfoIndex repositoryInfoIndex;
    @StepParameterObject
    private final HttpRequestRetryStepParameters retryPolicy = new HttpRequestRetryStepParameters(HttpRequestRetryPolicy.AZURE_DEVOPS);
    @StepParameter(value="branch-lookup-path", optional=true)
    private final List<String> branchLookupPaths = new ArrayList<String>();
    @StepParameter(value="non-branched-mode")
    private boolean nonBranchedMode;
    private final Logger interactionLogger;

    public TfsRepositoryConnector(Logger interactionLogger) {
        this.interactionLogger = interactionLogger;
    }

    @Override
    protected TfsRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        return new TfsRepositoryConnection(this.getBaseParameters(), this.getExternalCredentials(), this.branchLookupPaths, this.uniformPathCasingIndex, this.repositoryInfoIndex, this.retryPolicy.createRetryPolicy(), this.interactionLogger, this.nonBranchedMode);
    }
}

