/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.teamscale.index.repository.tfs.client.model.ETfvcChangeType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class TfvcChangeTypeDto {
    private static final String EMPTY_VALUE_MESSAGE = "Change type cannot be empty - choose EchangeType.NONE instead.";
    private static final String CHANGE_VALUE_DELIMITER = ",";
    private final Set<ETfvcChangeType> values;

    public Set<ETfvcChangeType> getValues() {
        return this.values;
    }

    public TfvcChangeTypeDto(ETfvcChangeType ... values) {
        CCSMAssert.isFalse((values.length == 0 ? 1 : 0) != 0, (String)EMPTY_VALUE_MESSAGE);
        this.values = Set.of(values);
    }

    public boolean contains(ETfvcChangeType changeType) {
        return this.values.contains((Object)changeType);
    }

    public boolean containsAny(TfvcChangeTypeDto changeType) {
        return changeType.values.stream().anyMatch(this.values::contains);
    }

    @JsonValue
    String serialize() {
        StringBuilder listOfValuesBuilder = new StringBuilder();
        this.values.forEach(value -> listOfValuesBuilder.append(String.valueOf(value) + CHANGE_VALUE_DELIMITER));
        return listOfValuesBuilder.substring(0, listOfValuesBuilder.length() - 2);
    }

    @JsonCreator
    TfvcChangeTypeDto(String valueString) {
        List<String> values = StringUtils.splitToList((String)valueString, (String)CHANGE_VALUE_DELIMITER).stream().map(value -> StringUtils.strip((String)value, (String)" ")).toList();
        this.values = values.stream().map(ETfvcChangeType::getByValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        CCSMAssert.isFalse((boolean)values.isEmpty(), (String)EMPTY_VALUE_MESSAGE);
    }
}

