/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.index.issues.IssueDescriber;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.WorkItemDescriberBase;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.jspecify.annotations.Nullable;

public class SpecItemDescriber
extends IssueDescriber<SpecItem> {
    public static final String CODE_REFERENCES_KEY = "codeReferences";
    public static final String TEST_REFERENCES_KEY = "testReferences";

    public SpecItemDescriber() {
        this((com.teamscale.wia.SpecItemDescriber<SpecItem>)new com.teamscale.wia.SpecItemDescriber());
    }

    private SpecItemDescriber(com.teamscale.wia.SpecItemDescriber<SpecItem> delegate) {
        super(delegate);
    }

    @Override
    public List<String> getUnmanagedKeys() {
        return List.of(CODE_REFERENCES_KEY, TEST_REFERENCES_KEY);
    }

    @Override
    public EKeyedObjectType getType(String key) {
        String string = key;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CODE_REFERENCES_KEY, TEST_REFERENCES_KEY}, (String)string, n)) {
            case 0, 1 -> EKeyedObjectType.NUMBER;
            default -> super.getType(key);
        };
    }

    @Override
    public List<String> getKeys(SpecItem issue) {
        List<String> result = super.getKeys(issue);
        result.addAll(issue.getLinkRoles());
        this.addLinkRolesMapping(issue.getLinkRoles());
        this.addFieldTypeMapping((List<String>)issue.getAdditionalFieldNames(), (List<String>)issue.getAdditionalFieldTypes());
        return result;
    }

    public void addLinkRolesMapping(Collection<String> linkRoles) {
        TreeMap<String, EKeyedObjectType> mapping = new TreeMap<String, EKeyedObjectType>();
        for (String linkRole : linkRoles) {
            mapping.put(linkRole, EKeyedObjectType.STRING_LIST);
        }
        this.addFieldTypeMappings(mapping);
    }

    private void addFieldTypeMapping(List<String> additionalFieldNames, List<String> additionalFieldTypes) {
        HashMap mapping = new HashMap();
        if (additionalFieldTypes.isEmpty()) {
            additionalFieldNames.forEach(name -> mapping.put(name, EKeyedObjectType.STRING));
        } else {
            CollectionUtils.forEach(additionalFieldNames, additionalFieldTypes, (name, type) -> {
                EKeyedObjectType objectType = (EKeyedObjectType)EnumUtils.valueOfIgnoreCase(EKeyedObjectType.class, (String)type);
                if (objectType == null) {
                    objectType = EKeyedObjectType.STRING;
                }
                mapping.put(name, objectType);
            });
        }
        this.addFieldTypeMappings(mapping);
    }

    @Override
    public Function<SpecItem, String> getValueAccessor(String key) {
        return issue -> this.getValue((SpecItem)issue, key);
    }

    private @Nullable String getValue(SpecItem issue, String key) {
        String value = super.getValueAccessor(key).apply(issue);
        if (value != null) {
            return value;
        }
        List linkedSpecItems = issue.getLinkedSpecItems(key);
        if (linkedSpecItems.isEmpty()) {
            return null;
        }
        return linkedSpecItems.stream().map(TeamscaleIssueId::getExternalId).collect(Collectors.joining(", "));
    }

    @Override
    public Comparator<SpecItem> getValueComparator(String key) {
        return super.getValueComparator(key).thenComparing(specItem -> specItem.getLinkedSpecItems(key), CollectionUtils.getListComparator((Comparator)WorkItemDescriberBase.IssueIdComparator.INSTANCE));
    }
}

