/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.WiaUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.jspecify.annotations.NonNull;

@Index(name="spec-items", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class SpecItemIndex
extends IssueIndexBase<SpecItem> {
    public static final String INDEX_NAME = "spec-items";

    public SpecItemIndex(IStore store) {
        super(store);
    }

    public static String matchRequirementsManagementConnectorIdToBranchName(String connectorId) {
        return WiaUtils.getWorkItemConnectorBranchName((String)connectorId);
    }

    public static boolean isRequirementsManagementConnectorBranch(String branch) {
        return WiaUtils.isWorkItemConnectorBranch((String)branch);
    }

    public static Set<String> getRequirementManagementConnectorBranches(ProjectConfiguration projectConfiguration) {
        return SpecItemIndex.getRequirementManagementConnectorIds(projectConfiguration).stream().map(SpecItemIndex::matchRequirementsManagementConnectorIdToBranchName).collect(Collectors.toSet());
    }

    public static @NonNull Set<String> getRequirementManagementConnectorIds(ProjectConfiguration projectConfiguration) {
        List requirementManagementConnectors = projectConfiguration.getConnectorsByNames((Set)ERequirementsManagementTool.getReadableNames());
        return requirementManagementConnectors.stream().map(ConnectorConfiguration::getIdentifier).collect(Collectors.toSet());
    }

    public static Set<String> getPossibleSpecItemBranches(String codeBranch, ProjectConfiguration projectConfiguration) {
        HashSet<String> branches = new HashSet<String>();
        branches.add(codeBranch);
        if (projectConfiguration != null) {
            branches.addAll(SpecItemIndex.getRequirementManagementConnectorBranches(projectConfiguration));
        }
        return branches;
    }
}

