/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.codebeamer;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.IWorkItemCleanupStrategy;
import com.teamscale.index.issues.cleanup.NoOpCleanupStrategy;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleaner;
import com.teamscale.index.issues.codebeamer.CodebeamerSynchronizerBase;
import com.teamscale.index.issues.codebeamer.client.model.Association;
import com.teamscale.index.issues.codebeamer.client.model.EDescriptionFormat;
import com.teamscale.index.issues.codebeamer.client.model.MarkupRequest;
import com.teamscale.index.issues.codebeamer.client.model.Tracker;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItem;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemField;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemRelationsResult;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemsRequest;
import com.teamscale.index.issues.codebeamer.client.model.field_values.AbstractFieldValue;
import com.teamscale.index.issues.codebeamer.client.model.field_values.WikiTextFieldValue;
import com.teamscale.index.issues.codebeamer.client.model.references.TrackerItemReference;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import retrofit2.Call;
import retrofit2.Response;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class CodebeamerSpecItemSynchronizer
extends CodebeamerSynchronizerBase<SpecItem> {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    protected SpecItemIndex previousIssueIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected SpecItemHistoryIndex specItemHistoryIndex;
    @StepParameterObject
    private final OnceEveryDayCleanupStrategy baseCleanupStrategy = new OnceEveryDayCleanupStrategy();
    @StepParameter(value="cleanup-enabled", optional=true)
    protected boolean cleanupEnabled = false;
    @StepParameter(value="Tracker to Types Mapping", optional=true)
    private final PairList<String, String> trackerNameToTypeMapping = new PairList();
    private Map<Integer, List<Association>> trackerItemRelationsResult;
    private IWorkItemCleanupStrategy resolvedCleanupStrategy;

    @Override
    protected IssueIndexBase<SpecItem> getWorkItemIndex() {
        return this.previousIssueIndex;
    }

    @Override
    protected IIssueHistoryIndex<SpecItem> getIssueHistoryIndex() {
        return this.specItemHistoryIndex;
    }

    @Override
    protected void init() throws BugTrackerException {
        super.init();
        this.initCleanupStrategy();
    }

    private void initCleanupStrategy() {
        this.resolvedCleanupStrategy = this.cleanupEnabled ? this.baseCleanupStrategy : new NoOpCleanupStrategy();
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        List<TrackerItem> trackerItems = this.retrieveUpdatedTrackerItems(Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp));
        if (!trackerItems.isEmpty()) {
            this.fetchTrackerItemRelations(trackerItems);
            this.fetchTrackerItemFields(trackerItems);
        }
        Map typeAbbreviation = this.includedTrackerTypes.toMap();
        Map trackerNamesToTypes = this.trackerNameToTypeMapping.toMap();
        List<SpecItem> workItems = trackerItems.stream().map(trackerItem -> this.createIssue((TrackerItem)trackerItem, this.getUrl(), (Map<String, String>)typeAbbreviation, startTimestamp, (Map<String, String>)trackerNamesToTypes)).toList();
        IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder builder = this.resultBuilder();
        builder.addItemsWithAuthor(PairList.zip(workItems, Stream.generate(() -> "Teamscale").limit(workItems.size()).toList())).addDeletions(this.performCleanupIfNecessary());
        return builder.build();
    }

    private Map<TeamscaleIssueId, Long> performCleanupIfNecessary() throws BugTrackerException, StorageException {
        return new WorkItemCleaner<SpecItem>(this.getWorkItemIndex(), this.getIssueHistoryIndex(), this.connectorId, this.resolvedCleanupStrategy).performCleanupIfNecessary(this.getCurrentImportStart(), () -> new HashSet<String>(this.getAllTrackerItemIds()));
    }

    private List<String> getAllTrackerItemIds() throws BugTrackerException {
        try {
            return this.retrieveUpdatedTrackerItems(0L).stream().map(item -> String.valueOf(item.getId())).toList();
        }
        catch (StorageException e) {
            throw new BugTrackerException("Could not fetch all tracker items", e);
        }
    }

    private void fetchTrackerItemFields(List<TrackerItem> trackerItems) throws BugTrackerException {
        Map<Integer, Integer> trackerToProject = this.fetchTrackerToProjectMapping(trackerItems);
        for (TrackerItem trackerItem : trackerItems) {
            this.fetchTrackerItemFields(trackerItem);
            int projectId = trackerToProject.get(trackerItem.getTracker().getId());
            this.convertWikiTextFieldsToHTML(trackerItem, projectId);
        }
    }

    private Map<Integer, Integer> fetchTrackerToProjectMapping(List<TrackerItem> trackerItems) throws BugTrackerException {
        List<Integer> trackerIds = trackerItems.stream().map(i -> i.getTracker().getId()).distinct().toList();
        HashMap<Integer, Integer> trackerToProject = new HashMap<Integer, Integer>();
        for (Integer trackerId : trackerIds) {
            try {
                Response trackerResponse = this.codebeamerClient.getTracker(trackerId).execute();
                if (trackerResponse.body() != null) {
                    int projectId = ((Tracker)trackerResponse.body()).getProjectId();
                    trackerToProject.put(trackerId, projectId);
                    continue;
                }
                LOGGER.error("Could not fetch tracker from codebeamer due to error: %s".formatted(trackerResponse.errorBody()));
            }
            catch (IOException e) {
                throw new BugTrackerException("Could not fetch trackers from codebeamer.", e);
            }
        }
        return trackerToProject;
    }

    private void fetchTrackerItemFields(TrackerItem trackerItem) throws BugTrackerException {
        Call<TrackerItemField> trackerItemFieldsCall = this.codebeamerClient.getTrackerItemFields(trackerItem.getId());
        try {
            Response response = trackerItemFieldsCall.execute();
            if (response.body() != null) {
                trackerItem.setFields(((TrackerItemField)response.body()).getAllFields());
            } else {
                LOGGER.error("Could not find fields of item with ID %d due to error: %s".formatted(trackerItem.getId(), response.errorBody()));
            }
        }
        catch (IOException e) {
            throw new BugTrackerException("Could not fetch fields of tracker item " + trackerItem.getId(), e);
        }
    }

    private void fetchTrackerItemRelations(List<TrackerItem> trackerItems) throws BugTrackerException {
        this.trackerItemRelationsResult = new HashMap<Integer, List<Association>>();
        List<TrackerItemReference> trackerItemReferences = trackerItems.stream().map(TrackerItem::toTrackerItemReference).toList();
        TrackerItemsRequest request = new TrackerItemsRequest(trackerItemReferences, "");
        Call<List<TrackerItemRelationsResult>> call = this.codebeamerClient.getTrackerItemRelations(request);
        try {
            List relationsResults = (List)call.execute().body();
            if (relationsResults == null) {
                return;
            }
            for (TrackerItemRelationsResult relationsResult : relationsResults) {
                List<Association> associations = relationsResult.resolveAssociations(this.codebeamerClient);
                this.trackerItemRelationsResult.put(relationsResult.itemId().id(), associations);
            }
        }
        catch (IOException e) {
            throw new BugTrackerException("Could not fetch item relations from codebeamer.", e);
        }
    }

    private void convertWikiTextFieldsToHTML(TrackerItem trackerItem, int projectId) throws BugTrackerException {
        for (Map.Entry<String, AbstractFieldValue> entry : trackerItem.getFields().entrySet()) {
            AbstractFieldValue abstractFieldValue = entry.getValue();
            if (!(abstractFieldValue instanceof WikiTextFieldValue)) continue;
            WikiTextFieldValue wikiField = (WikiTextFieldValue)abstractFieldValue;
            String markup = wikiField.getValue();
            String html = this.convertMarkupToHTML(markup, trackerItem.getId(), projectId);
            wikiField.setValue(html);
        }
        if (trackerItem.getDescriptionFormat() == EDescriptionFormat.WIKI) {
            String markup = trackerItem.getDescription();
            String html = this.convertMarkupToHTML(markup, trackerItem.getId(), projectId);
            trackerItem.setDescription(html);
        }
    }

    private String convertMarkupToHTML(String markup, int itemID, int projectId) throws BugTrackerException {
        if (StringUtils.isEmpty((String)markup)) {
            return markup;
        }
        try {
            Response htmlResponse = this.codebeamerClient.wiki2html(projectId, new MarkupRequest(markup, itemID)).execute();
            if (htmlResponse.isSuccessful()) {
                return (String)htmlResponse.body();
            }
            LOGGER.error("Could not convert wiki markup to html for item %s".formatted(itemID));
            return markup;
        }
        catch (IOException e) {
            throw new BugTrackerException("Could not convert wiki markup to html", e);
        }
    }

    @Override
    protected SpecItem createIssue(TrackerItem trackerItem, String url, Map<String, String> typeAbbreviation, long startTimestamp, Map<String, String> trackerNameToTypeMapping) {
        SpecItem specItem = trackerItem.toSpecItem(this.connectorId, url, this.trackerItemRelationsResult.get(trackerItem.getId()), typeAbbreviation, trackerNameToTypeMapping, startTimestamp, this.getCodeBeamerServerTimeZone());
        if (this.isTestItem(new TeamscaleIssueTypeInfo(trackerItem.getTypeName(), typeAbbreviation.get(trackerItem.getTypeName())))) {
            return trackerItem.toManualTestCase(specItem);
        }
        return specItem;
    }
}

