/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.rtc;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.rtc.RtcIssueSynchronizer;
import com.teamscale.index.issues.rtc.RtcSynchronizerBase;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItem;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.tools.rtc.model.ERtcWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.tools.util.WorkItemUtils;
import com.teamscale.index.requirements_tracing.triggers.rtc.RtcWorkItemLinkHelper;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class RtcSpecItemSynchronizer
extends RtcSynchronizerBase<SpecItem> {
    public static final String WORK_ITEM_LINKS_PARAMETER = "work-item-links";
    @StepParameter(value="work-item-links", optional=true)
    private List<String> additionalWorkItemLinks = new ArrayList<String>();
    @StepParameter(value="item-type", optional=true)
    private final PairList<String, String> itemTypes = new PairList();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected SpecItemHistoryIndex specItemHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private SpecItemIndex previousSpecItemIndex;
    private Map<String, String> rtcInternalToVisibleId = Collections.emptyMap();

    @Override
    protected IIssueHistoryIndex<SpecItem> getIssueHistoryIndex() {
        return this.specItemHistoryIndex;
    }

    @Override
    protected IssueIndexBase<SpecItem> getWorkItemIndex() {
        return this.previousSpecItemIndex;
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        List workItemLinkTypes = CollectionUtils.map(this.additionalWorkItemLinks, ERtcWorkItemLinkRole::getTypeForReadableLinkRole);
        try {
            List<RtcWorkItem> workItems = this.client.fetchModifiedWorkItems(new ArrayList<String>(this.projects), Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp), (PairList<String, Boolean>)this.customFields, this.getItemTypes(), this.additionalFieldFilter, workItemLinkTypes);
            if (!this.additionalWorkItemLinks.isEmpty()) {
                this.rtcInternalToVisibleId = workItems.stream().collect(Collectors.toMap(RtcWorkItem::getItemId, RtcWorkItem::getIdAsString));
            }
            List issues = this.retrieveIssueHistory(workItems, lastScanTimestamp, startTimestamp, workItemLinkTypes);
            return this.resultBuilder().addItems(issues).build();
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Could not retrieve updated work items", e);
        }
    }

    @Override
    protected SpecItem createIssue(RtcWorkItem workItem, String connectorId, long overrideModificationTimestamp) {
        TeamscaleIssue teamscaleIssue = RtcIssueSynchronizer.createTeamscaleIssue(workItem, connectorId, overrideModificationTimestamp);
        Map<String, List<String>> linkRolesAndLinkedSpecItems = RtcWorkItemLinkHelper.extractLinkRoles(workItem, this.rtcInternalToVisibleId);
        PairList linkRolesAndLinkedSpecItemsAsPairList = PairList.fromMap(linkRolesAndLinkedSpecItems);
        UnmodifiableList linkRoles = linkRolesAndLinkedSpecItemsAsPairList.getFirstList();
        UnmodifiableList linkedSpecItems = linkRolesAndLinkedSpecItemsAsPairList.getSecondList();
        String type = teamscaleIssue.getAdditionalFieldValue("Type");
        if (type == null) {
            return new SpecItem(teamscaleIssue, Collections.emptyList(), Collections.emptyList(), (List)linkRoles, (List)linkedSpecItems, null, null);
        }
        String typeAbbreviation = (String)this.itemTypes.toMap().get(type);
        if (typeAbbreviation == null) {
            typeAbbreviation = WorkItemUtils.generateWorkItemNameAbbreviation(type);
        }
        return new SpecItem(teamscaleIssue, Collections.emptyList(), Collections.emptyList(), (List)linkRoles, (List)linkedSpecItems, type, typeAbbreviation);
    }

    @Override
    protected Set<String> getItemTypes() {
        return new HashSet<String>((Collection<String>)this.itemTypes.getFirstList());
    }
}

