/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public abstract class ContainerSynchronizerBase
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private ContainerIndex containerIndex;
    private final Map<String, ContainerInfo> containersByPath = new HashMap<String, ContainerInfo>();
    private final Set<String> deletedPaths = new HashSet<String>();

    private static void insertParentContainerPaths(List<String> paths, Set<String> containerPaths) {
        for (String path : paths) {
            while (containerPaths.add(path = UniformPathUtils.getParentPath((String)path))) {
            }
        }
    }

    public void execute() throws StorageException {
        String parentPath;
        List<String> addedOrChangedKeys = this.getAddedOrChangedFiles();
        List<String> contentHashes = this.getContentHashesForAddedOrChangedKeys(addedOrChangedKeys);
        this.loadExistingContainers(addedOrChangedKeys);
        for (String elementPath : this.getDeletedKeys()) {
            parentPath = UniformPathUtils.getParentPath((String)elementPath);
            ContainerInfo container = this.containersByPath.get(parentPath);
            if (container != null) {
                container.deleteChild(elementPath);
                this.deleteContainerIfEmpty(container);
            }
            this.updateDeepPathLinks(elementPath);
        }
        for (int i = 0; i < addedOrChangedKeys.size(); ++i) {
            String elementPath;
            elementPath = addedOrChangedKeys.get(i);
            parentPath = UniformPathUtils.getParentPath((String)elementPath);
            this.getOrCreateContainer(parentPath).insertOrUpdateChildElementWithHash(elementPath, contentHashes.get(i));
            this.updateDeepPathLinks(elementPath);
        }
        this.writeToIndex();
    }

    protected abstract List<String> getDeletedKeys() throws StorageException;

    private void loadExistingContainers(List<String> addedOrChangedKeys) throws StorageException {
        HashSet<String> containerPaths = new HashSet<String>();
        ContainerSynchronizerBase.insertParentContainerPaths(addedOrChangedKeys, containerPaths);
        List<String> deletedKeys = this.getDeletedKeys();
        ContainerSynchronizerBase.insertParentContainerPaths(deletedKeys, containerPaths);
        LOGGER.info("Delta of size " + (addedOrChangedKeys.size() + deletedKeys.size()) + " caused " + containerPaths.size() + " container paths.");
        for (ContainerInfo container : this.containerIndex.getContainers(new ArrayList<String>(containerPaths))) {
            if (container == null) continue;
            this.containersByPath.put(container.getUniformPath(), container);
        }
    }

    protected abstract List<String> getContentHashesForAddedOrChangedKeys(List<String> var1) throws StorageException;

    protected abstract List<String> getAddedOrChangedFiles() throws StorageException;

    private ContainerInfo getOrCreateContainer(String path) {
        ContainerInfo container = this.containersByPath.get(path);
        if (container == null) {
            container = new ContainerInfo(path);
            this.containersByPath.put(path, container);
            if (!StringUtils.isEmpty((String)path)) {
                String parentPath = UniformPathUtils.getParentPath((String)path);
                ContainerInfo parent = this.getOrCreateContainer(parentPath);
                parent.insertOrUpdateChildContainer(path, "");
            }
        }
        return container;
    }

    private void deleteContainerIfEmpty(ContainerInfo container) {
        String containerPathString = container.getUniformPath();
        UniformPath containerPath = UniformPathCompatibilityUtil.convert((String)containerPathString);
        if (!container.isEmpty() || containerPath.isRoot()) {
            return;
        }
        if (!this.deletedPaths.add(containerPathString)) {
            return;
        }
        this.containersByPath.remove(containerPathString);
        String parentPath = UniformPathUtils.getParentPath((String)containerPathString);
        ContainerInfo parentContainer = this.containersByPath.get(parentPath);
        if (parentContainer != null) {
            parentContainer.deleteChild(containerPathString);
            this.deleteContainerIfEmpty(parentContainer);
        }
    }

    private void updateDeepPathLinks(String elementPath) throws StorageException {
        String parentPath = UniformPathUtils.getParentPath((String)elementPath);
        if (this.deletedPaths.contains(parentPath)) {
            parentPath = UniformPathUtils.getParentPath((String)parentPath);
        }
        ContainerInfo parentInfo = this.containersByPath.get(parentPath);
        while (parentInfo != null) {
            if (CodeScopesMetricsUtils.isCodeScopeBasePath(parentPath) || ContainerSynchronizerBase.getNumberOfNonCodeScopeChildren(parentInfo) != 1L) {
                parentInfo.setDeepestRelativePathWithMoreThanOneChild("");
            } else {
                parentInfo.setDeepestRelativePathWithMoreThanOneChild(this.getSingleChildDeepPath(parentInfo));
            }
            if (StringUtils.isEmpty((String)parentPath)) break;
            String deepPath = parentInfo.getDeepestRelativePathWithMoreThanOneChild();
            parentInfo = this.containersByPath.get(UniformPathUtils.getParentPath((String)parentPath));
            if (parentInfo == null) continue;
            parentInfo.insertOrUpdateChildContainer(parentPath, deepPath);
            parentPath = parentInfo.getUniformPath();
        }
    }

    private static long getNumberOfNonCodeScopeChildren(ContainerInfo containerInfo) {
        return containerInfo.getChildren().stream().filter(uniformPath -> !CodeScopesMetricsUtils.isCodeScopesRootPath(uniformPath)).count();
    }

    private String getSingleChildDeepPath(ContainerInfo container) throws StorageException {
        String childPath = (String)CollectionUtils.getAny(container.getChildren());
        if (!container.childIsAContainer(childPath)) {
            return "";
        }
        ContainerInfo childContainer = this.containersByPath.get(childPath);
        if (childContainer == null) {
            childContainer = this.containerIndex.getContainer(childPath);
            this.containersByPath.put(childPath, childContainer);
        }
        String childName = UniformPathUtils.getElementName((String)childPath);
        if (StringUtils.isEmpty((String)childContainer.getDeepestRelativePathWithMoreThanOneChild())) {
            return childName;
        }
        return childName + UniformPathUtils.SEPARATOR + childContainer.getDeepestRelativePathWithMoreThanOneChild();
    }

    private void writeToIndex() throws StorageException {
        this.containerIndex.removeValues(new ArrayList<String>(this.deletedPaths));
        PairList newValues = new PairList();
        for (Map.Entry<String, ContainerInfo> entry : this.containersByPath.entrySet()) {
            newValues.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.containerIndex.setContainers((PairList<String, ContainerInfo>)newValues);
        LOGGER.info("Deleted " + this.deletedPaths.size() + " entries and updated " + newValues.size() + " entries");
    }
}

