/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.utils.StoreWriteBuffer;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.RepositoryContentUpdaterUtils;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public abstract class ReportContentIndexBase
extends IndexBase
implements IProjectIndex {
    protected ReportContentIndexBase(IStore store) {
        super(store);
    }

    public List<@Nullable ReportContent> getReportContents(List<String> uniformPaths) throws StorageException {
        return StorageUtils.deserializeValues((List)this.store.getWithStrings(uniformPaths));
    }

    public void setReportContents(PairList<UniformPath, ReportContent> uniformPathsAndContents) throws StorageException {
        for (int i = 0; i < uniformPathsAndContents.size(); ++i) {
            EReportFormat format = ((ReportContent)uniformPathsAndContents.getSecond((int)i)).format;
            if (this.isAcceptedReportFormat(format)) continue;
            throw new StorageException("Format " + String.valueOf((Object)format) + " of report stored at path " + String.valueOf(uniformPathsAndContents.getFirst(i)) + " is not supported by this index!");
        }
        this.store.performWithLock(() -> {
            StoreWriteBuffer storeWriteBuffer = new StoreWriteBuffer((IStore)this.store);
            for (Pair pathAndContent : uniformPathsAndContents) {
                storeWriteBuffer.add(StringUtils.stringToBytes((String)((UniformPath)pathAndContent.getFirst()).toString()), StorageUtils.serialize((Serializable)((Serializable)pathAndContent.getSecond())));
            }
            storeWriteBuffer.flush();
        });
    }

    protected abstract boolean isAcceptedReportFormat(EReportFormat var1);

    public void removeReportContents(List<String> uniformPathsToDelete) throws StorageException {
        this.store.removeWithStrings(uniformPathsToDelete);
    }

    @IndexValueClass
    public static class ReportContent
    implements Serializable,
    ExternalAnalysisReportArchiveIndex.IStringRepresentationProvider {
        public final EReportFormat format;
        public final long timestamp;
        public final byte[] content;
        public final String encodingName;
        public final @Nullable String partition;
        public final String connectorId;
        private static final long serialVersionUID = 1L;

        public ReportContent(EReportFormat format, long timestamp, byte[] content, Charset encoding, @Nullable String partition, String connectorId) {
            this.format = format;
            this.timestamp = timestamp;
            this.content = content;
            this.encodingName = encoding.name();
            this.partition = partition;
            this.connectorId = connectorId;
        }

        public String getContentAsString() {
            return RepositoryContentUpdaterUtils.getTextContent(this.content, Charset.forName(this.encodingName));
        }

        public String getPartitionOrElse(String defaultValue) {
            if (this.partition == null) {
                return defaultValue;
            }
            return this.partition;
        }

        @Override
        public String convertToString() {
            return this.getContentAsString();
        }
    }
}

