/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.resolution_strategy;

import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import com.teamscale.index.resource.resolution_strategy.IndexResourceResolutionStrategyBase;
import com.teamscale.index.resource.utils.EResourceType;
import com.teamscale.wia.WiaUtils;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeResourceResolutionStrategy
extends IndexResourceResolutionStrategyBase {
    private final ProjectStorageSystem projectStorageSystem;

    public CodeResourceResolutionStrategy(ProjectStorageSystem projectStorageSystem) {
        this.projectStorageSystem = projectStorageSystem;
    }

    @Override
    public ContainerInfo getContainerInfoForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        ContainerInfo container = super.getContainerInfoForPath(uniformPath, historyAccessOption);
        if (container != null) {
            container.removeMatchingChildren(UniformPathUtils::isArchitectureFile);
            container.removeMatchingChildren(CodeScopesMetricsUtils::isCodeScopesPath);
            container.removeMatchingChildren(WiaUtils::isWorkItemPath);
        }
        return container;
    }

    @Override
    protected ContainerIndex openIndex(HistoryAccessOption historyAccessOption) throws StorageException {
        return (ContainerIndex)this.projectStorageSystem.openProjectIndex(ContainerIndex.class, "container", historyAccessOption);
    }

    @Override
    protected Map<String, EResourceType> getChildTypes(String uniformPath, ContainerIndex index) throws StorageException {
        return super.getChildTypes(uniformPath, index).entrySet().stream().filter(child -> !UniformPathUtils.isArchitectureFile((String)((String)child.getKey()))).filter(child -> !WiaUtils.isWorkItemPath((String)((String)child.getKey()))).filter(child -> !CodeScopesMetricsUtils.isCodeScopesPath((String)child.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

