/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy.computation;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemReferenceBase;
import com.teamscale.index.issue_reference.SpecItemReferenceElement;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.PartitionAndPath;

public class SpecItemMetricCalculator {
    public static int computeSpecItemVerifiesCountMetric(Collection<? extends Collection<SpecItemCodeReference>> codeReferences, Collection<? extends Collection<PartitionAndPath>> testReferences, Collection<Set<SpecItemReferenceElement>> verifiedSpecItemReferences) {
        int codeReferenceTests = Math.toIntExact(codeReferences.stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(SpecItemReferenceBase::isTestReference).count());
        int testReferenceTests = Math.toIntExact(testReferences.stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).count());
        int specItemReferenceTests = Math.toIntExact(verifiedSpecItemReferences.stream().mapToLong(Collection::size).sum());
        return codeReferenceTests + testReferenceTests + specItemReferenceTests;
    }

    public static int computeTestedItemsCount(List<TeamscaleIssueId> specItemIds, Map<TeamscaleIssueId, List<SpecItemCodeReference>> codeReferences, Map<TeamscaleIssueId, List<PartitionAndPath>> testReferences, Map<TeamscaleIssueId, Set<SpecItemReferenceElement>> verifiedSpecItemReferences) {
        int testedItemsCount = 0;
        for (TeamscaleIssueId specItemId : specItemIds) {
            if (!SpecItemMetricCalculator.isItemReferenced(codeReferences, specItemId) && !SpecItemMetricCalculator.isItemReferencedByTest(testReferences, specItemId) && !SpecItemMetricCalculator.isItemReferencedBySpecItem(verifiedSpecItemReferences, specItemId)) continue;
            ++testedItemsCount;
        }
        return testedItemsCount;
    }

    public static int computeItemsWithProductionCodeReferencesCount(Map<TeamscaleIssueId, List<SpecItemCodeReference>> codeReferences) {
        return Math.toIntExact(codeReferences.values().stream().filter(Objects::nonNull).filter(references -> references.stream().anyMatch(Predicate.not(SpecItemCodeReference::isTestReference))).count());
    }

    public static int computeProductionCodeReferencesCount(Collection<? extends Collection<SpecItemCodeReference>> codeReferences) {
        return Math.toIntExact(codeReferences.stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(reference -> !reference.isTestReference()).count());
    }

    private static boolean isItemReferenced(Map<TeamscaleIssueId, List<SpecItemCodeReference>> codeReferences, TeamscaleIssueId specItemId) {
        List<SpecItemCodeReference> itemCodeReferences = codeReferences.get(specItemId);
        if (itemCodeReferences == null) {
            return false;
        }
        return itemCodeReferences.stream().anyMatch(SpecItemReferenceBase::isTestReference);
    }

    private static boolean isItemReferencedByTest(Map<TeamscaleIssueId, List<PartitionAndPath>> testReferences, TeamscaleIssueId specItemId) {
        List<PartitionAndPath> itemTestReferences = testReferences.get(specItemId);
        return itemTestReferences != null && !itemTestReferences.isEmpty();
    }

    private static boolean isItemReferencedBySpecItem(Map<TeamscaleIssueId, Set<SpecItemReferenceElement>> specItemReferencesByIssueId, TeamscaleIssueId specItemId) {
        Set<SpecItemReferenceElement> specItemReferences = specItemReferencesByIssueId.get(specItemId);
        if (specItemReferences == null) {
            return false;
        }
        return !specItemReferences.isEmpty();
    }

    public static double computeSpecItemCoverageMetric(int referencedSpecItemCount, int totalSpecItemCount) {
        if (totalSpecItemCount == 0) {
            return 0.0;
        }
        return (double)referencedSpecItemCount / (double)totalSpecItemCount;
    }
}

