/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.authenticate.aws.AwsCredentialProcessVariableDefinition;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CredentialsProcess {
    private static final Pattern FORBIDDEN_CHARACTER_PATTERN = Pattern.compile("[^a-zA-Z0-9\\-._]");
    private static final String ALLOWED_CHARACTERS_HINT = "Allowed characters are [A-Za-z0-9] and the characters \".\" (dot), \"-\" (minus), and \"_\" (underscore).";
    private final String baseCommand;
    private final UnmodifiableMap<String, String> environmentVariables;
    public static final String CREDENTIALS_PROCESS_COMMAND_PROPERTY_NAME = "com.teamscale.s3.credentials-process-command";

    @VisibleForTesting
    CredentialsProcess(String baseCommand, UnmodifiableMap<String, String> environmentVariables) throws ProjectConfigurationException {
        for (Map.Entry entry : environmentVariables.entrySet()) {
            CredentialsProcess.checkValidEnvironmentVariable(entry);
        }
        this.baseCommand = baseCommand;
        this.environmentVariables = environmentVariables;
    }

    private static void checkValidEnvironmentVariable(Map.Entry<String, String> keyToValue) throws ProjectConfigurationException {
        String key = keyToValue.getKey();
        CredentialsProcess.checkValidKey(key);
        CredentialsProcess.checkValidValue(keyToValue.getValue(), key);
    }

    private static void checkValidKey(String key) throws ProjectConfigurationException {
        if (StringUtils.isEmpty((String)key)) {
            throw new ProjectConfigurationException("Empty string is not allowed for environment variable name!");
        }
        String illegalCharactersInKey = CredentialsProcess.getIllegalCharactersList(key);
        if (!StringUtils.isEmpty((String)illegalCharactersInKey)) {
            throw new ProjectConfigurationException("Illegal character(s) %s in environment variable %s! Allowed characters are [A-Za-z0-9] and the characters \".\" (dot), \"-\" (minus), and \"_\" (underscore).".formatted(illegalCharactersInKey, key));
        }
    }

    private static void checkValidValue(String value, String key) throws ProjectConfigurationException {
        if (StringUtils.isEmpty((String)value)) {
            throw new ProjectConfigurationException("Empty string is not allowed for value of environment variable %s!".formatted(value));
        }
        String illegalCharactersInValue = CredentialsProcess.getIllegalCharactersList(value);
        if (!StringUtils.isEmpty((String)illegalCharactersInValue)) {
            throw new ProjectConfigurationException("Illegal character(s) %s in value for environment variable %s! ".formatted(illegalCharactersInValue, key) + ALLOWED_CHARACTERS_HINT);
        }
    }

    private static @Nullable String getIllegalCharactersList(String input) {
        Matcher matcher = FORBIDDEN_CHARACTER_PATTERN.matcher(input);
        HashSet<String> illegalCharacters = new HashSet<String>();
        while (matcher.find()) {
            illegalCharacters.add(matcher.group());
        }
        if (illegalCharacters.isEmpty()) {
            return null;
        }
        return "[%s]".formatted(illegalCharacters.stream().map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
    }

    public static @NonNull CredentialsProcess readFromServerOptions(ServerOptionIndex index) throws StorageException, ProjectConfigurationException {
        String baseCommand = System.getProperty(CREDENTIALS_PROCESS_COMMAND_PROPERTY_NAME);
        if (baseCommand == null) {
            throw new ProjectConfigurationException(String.format("The JVM property \"%s\" must be set if \"%s\" is enabled", CREDENTIALS_PROCESS_COMMAND_PROPERTY_NAME, "Use Credentials Process"));
        }
        Map<String, String> variables = ServerOptionRegistry.getServerMultiOptionAll((String)"aws.credentials.process.variable", (ServerOptionIndex)index).values().stream().map(o -> (AwsCredentialProcessVariableDefinition)o).collect(Collectors.toMap(v -> v.name, v -> v.value));
        return new CredentialsProcess(baseCommand, (UnmodifiableMap<String, String>)CollectionUtils.asUnmodifiable(variables));
    }

    public String createCommand() {
        String variableString = this.environmentVariables.entrySet().stream().map(e -> String.format("%s=\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
        return String.format("%s %s", variableString, this.baseCommand);
    }
}

