/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ForceFullScan;
import com.teamscale.index.s3.S3ProjectConfigurationUtils;
import jakarta.ws.rs.NotFoundException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.lang.ObjectUtils;

public class S3BackupImportHandler {
    private final IndexLayer indexLayer;
    private final PublicProjectId projectId;

    public S3BackupImportHandler(IndexLayer indexLayer, PublicProjectId projectId) {
        this.indexLayer = indexLayer;
        this.projectId = projectId;
    }

    public void afterBackupImport() throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.projectId, (IndexLayer)this.indexLayer);
        ObjectUtils.requireNonNullElseThrow((Object)projectConfiguration, () -> {
            throw new NotFoundException("Project with ID '%s' was not found.".formatted(this.projectId));
        });
        if (!S3ProjectConfigurationUtils.hasS3StorageBackend(projectConfiguration, (ExternalStorageBackendIndex)this.indexLayer.openGlobalIndex(ExternalStorageBackendIndex.class)) && S3ProjectConfigurationUtils.getS3Connectors(projectConfiguration).isEmpty()) {
            return;
        }
        new S3ForceFullScan(this.indexLayer).setS3FullScan(this.projectId, false);
    }
}

