/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.sap;

import com.teamscale.index.sap.AbapTeamscaleSync;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="abap-teamscale-sync-index")
public class AbapTeamscaleSyncIndex
implements IGlobalIndex {
    private final ValueIndex<AbapTeamscaleSync> delegate;

    public AbapTeamscaleSyncIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateToUpdating(String sapSystemId, String syncId, Instant lastCommitTime) throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            this.delegate.setValue(AbapTeamscaleSyncIndex.makeKey(sapSystemId, syncId), (Object)AbapTeamscaleSync.createUpdating(lastCommitTime));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateToDone(String sapSystemId, String syncId) throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            AbapTeamscaleSync abapTeamscaleSync = (AbapTeamscaleSync)this.delegate.getValue(AbapTeamscaleSyncIndex.makeKey(sapSystemId, syncId));
            this.delegate.setValue(AbapTeamscaleSyncIndex.makeKey(sapSystemId, syncId), (Object)AbapTeamscaleSync.createDone(abapTeamscaleSync));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateToCanceled(String sapSystemId, String syncId) throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            this.delegate.setValue(AbapTeamscaleSyncIndex.makeKey(sapSystemId, syncId), (Object)AbapTeamscaleSync.createCanceled());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> getSynchronizationId(String sapSystemId) throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            UnmodifiableList initiatedKeys = this.delegate.getEntriesStartingWith(AbapTeamscaleSyncIndex.makeKey(sapSystemId, "")).filter((key, synchronization) -> synchronization.getState() == AbapTeamscaleSync.State.INITIATED).getFirstList();
            if (initiatedKeys.isEmpty()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Optional.empty();
            }
            CCSMAssert.isTrue((initiatedKeys.size() == 1 ? 1 : 0) != 0, (String)"Exactly one initiated synchronization entry must exist.");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Optional.of(AbapTeamscaleSyncIndex.extractSynchronizationId((String)initiatedKeys.get(0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerAbapTeamscaleSync(String sapSystemId) throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            Optional<String> syncId = this.getSynchronizationId(sapSystemId);
            if (syncId.isPresent()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return syncId.get();
            }
            String newSyncId = UUID.randomUUID().toString();
            this.delegate.setValue(AbapTeamscaleSyncIndex.makeKey(sapSystemId, newSyncId), (Object)AbapTeamscaleSync.createInitiated());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return newSyncId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<AbapTeamscaleSync> getSynchronizationState(String sapSystemId, String syncId) throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Optional.ofNullable((AbapTeamscaleSync)this.delegate.getValue(AbapTeamscaleSyncIndex.makeKey(sapSystemId, syncId)));
        }
    }

    private static String makeKey(String sapSystemId, String syncId) {
        return sapSystemId + ":" + syncId;
    }

    private static String extractSynchronizationId(String key) {
        return StringUtils.getLastPart((String)key, (char)':');
    }

    public void removeAllStates() throws StorageException {
        this.delegate.removeAllEntries();
    }
}

