/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.finding;

import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysis;
import com.teamscale.index.simulink.analysis.finding.ThresholdFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.metric.NestingDepthMetric;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@SimulinkFindingAnalysis(name="Deep Nesting", description="Marks model with deep subsystem nesting. <br><br> A violating subsystem nesting path for the model can be found in the finding properties. <br> Up to 5 entries for subsystems with violating nesting depth can also be found in the finding properties.", group="Model Nesting Depth", qualityIndicator="Structure", enablement=EFindingEnablement.AUTO)
public class NestingDepthFinding
extends ThresholdFindingAnalysisBase {
    private static final String FINDING_MESSAGE = "Model violates subsystem nesting depth threshold: %d";
    private static final String DEEP_SUBSYSTEM_PROPERTY_NAME = "\"%s\" violates subsystem depth threshold.";
    private static final String DEEP_SUBSYSTEM_PROPERTY_INFO = "Subsystem Level: %d | Subsystem Depth: %d | Violating path: %s";
    private static final Comparator<SimulinkBlock> BY_DEPTH_COMPARATOR = Comparator.comparingInt(NestingDepthMetric::calculateSubsystemDepth);

    @Override
    protected void analyzeModel(SimulinkModel model) {
        int depth = NestingDepthMetric.calculateSubsystemDepth((SimulinkBlock)model);
        this.subsystemDepthViolation(depth).ifPresent(assessment -> this.createAndReportNestingDepthFinding((SimulinkBlock)model, (ETrafficLightColor)assessment, depth));
    }

    private void createAndReportNestingDepthFinding(SimulinkBlock model, ETrafficLightColor assessment, int depth) {
        IndexFinding finding = this.createFindingForBlock(model, String.format(FINDING_MESSAGE, depth), assessment);
        this.setFindingProperties(finding, Double.valueOf(depth));
        finding.addProperties(NestingDepthFinding.createNestingViolationProperty(model, depth));
        this.addSubsystemTableToFindingProperties(model, finding);
        this.reportFinding(finding);
    }

    private Optional<ETrafficLightColor> subsystemDepthViolation(int depth) {
        NumericThresholds thresholds = this.getThresholds();
        if (depth >= thresholds.getRedThreshold()) {
            return Optional.of(ETrafficLightColor.RED);
        }
        if (depth >= thresholds.getYellowThreshold()) {
            return Optional.of(ETrafficLightColor.YELLOW);
        }
        return Optional.empty();
    }

    private void addSubsystemTableToFindingProperties(SimulinkBlock model, IndexFinding finding) {
        ArrayList<SimulinkBlock> subsystems = new ArrayList<SimulinkBlock>(SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)false, (boolean)false));
        subsystems.sort(BY_DEPTH_COMPARATOR);
        Collections.reverse(subsystems);
        if (subsystems.size() > 5) {
            subsystems.subList(5, subsystems.size()).clear();
        }
        for (SimulinkBlock subsystem : subsystems) {
            int childDepth = NestingDepthMetric.calculateSubsystemDepth(subsystem);
            this.subsystemDepthViolation(childDepth).ifPresent(assessment -> {
                finding.addProperties(NestingDepthFinding.createNestingViolationProperty(subsystem, childDepth));
                this.addSecondaryLocationForBlock(finding, subsystem);
            });
        }
    }

    private static Map<String, Object> createNestingViolationProperty(SimulinkBlock block, int depth) {
        String propertyName = String.format(DEEP_SUBSYSTEM_PROPERTY_NAME, block.buildQualifiedName());
        SimulinkBlock deepestSubsystem = NestingDepthMetric.getDeepestSubsystem(block).orElse(block);
        String deepestNestedChildPath = String.format(DEEP_SUBSYSTEM_PROPERTY_INFO, NestingDepthMetric.getLevel(block), depth, deepestSubsystem.buildQualifiedName());
        return Map.of(propertyName, deepestNestedChildPath);
    }
}

