/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import com.teamscale.index.utils.StringPoolDeserializer;
import com.teamscale.index.utils.StringPoolSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="simulink-clone-fragments", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED}, valueClasses={byte[].class})
public class SimulinkCloneFragmentIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "simulink-clone-fragments";

    public SimulinkCloneFragmentIndex(IStore store) {
        super(store);
    }

    public void insertFragments(List<SimulinkCloneFragment> fragments) throws StorageException {
        Map<String, List<SimulinkCloneFragment>> fragmentByRawKey = fragments.stream().collect(Collectors.groupingBy(SimulinkCloneFragment::getRawKey));
        PairList keysValues = new PairList();
        for (Map.Entry<String, List<SimulinkCloneFragment>> entry : fragmentByRawKey.entrySet()) {
            keysValues.add((Object)entry.getKey(), (Object)SimulinkCloneFragmentIndex.serializeFragments(entry.getValue()));
        }
        this.store.putWithStrings(keysValues);
    }

    public void deleteFragmentsForModels(List<String> uniformPaths) throws StorageException {
        for (String uniformPath : uniformPaths) {
            this.store.removeByPrefix(StringUtils.stringToBytes((String)(uniformPath + "##")));
        }
    }

    public List<List<SimulinkCloneFragment>> getFragmentsForRawKeys(List<String> rawKeys) throws StorageException {
        List values = this.store.getWithStrings(rawKeys);
        ArrayList<List<SimulinkCloneFragment>> result = new ArrayList<List<SimulinkCloneFragment>>();
        for (int i = 0; i < rawKeys.size(); ++i) {
            Pair<String, String> uniformPathAndParentId = SimulinkCloneFragment.splitRawKey(rawKeys.get(i));
            result.add(SimulinkCloneFragmentIndex.deserializeFragments((String)uniformPathAndParentId.getFirst(), (String)uniformPathAndParentId.getSecond(), (byte[])values.get(i)));
        }
        return result;
    }

    public PairList<String, List<SimulinkCloneFragment>> getFragmentsForUniformPath(String uniformPath) throws StorageException {
        String prefix = uniformPath + "##";
        PairList result = new PairList();
        this.store.scan(prefix, (key, value) -> {
            String parentId = StringUtils.bytesToString((byte[])key).substring(prefix.length());
            List<SimulinkCloneFragment> fragments = SimulinkCloneFragmentIndex.deserializeFragments(uniformPath, parentId, value);
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)parentId, fragments);
            }
        });
        return result;
    }

    private static byte[] serializeFragments(final List<SimulinkCloneFragment> fragments) {
        fragments.sort(Comparator.comparing(SimulinkCloneFragment::getHash));
        StringPoolSerializer serializer = new StringPoolSerializer(){

            @Override
            protected void serializeData(DataOutputStream dos) throws IOException {
                dos.writeInt(fragments.size());
                for (SimulinkCloneFragment fragment : fragments) {
                    dos.writeLong(fragment.getHash());
                    List<String> blockNames = fragment.getBlockNames();
                    dos.writeByte(blockNames.size());
                    for (String blockName : blockNames) {
                        this.writeString(blockName, dos);
                    }
                }
            }
        };
        fragments.stream().flatMap(fragment -> fragment.getBlockNames().stream()).forEach(serializer::addString);
        return serializer.serialize();
    }

    private static List<SimulinkCloneFragment> deserializeFragments(final String uniformPath, final String parentId, byte[] data) {
        final ArrayList<SimulinkCloneFragment> result = new ArrayList<SimulinkCloneFragment>();
        if (data == null) {
            return result;
        }
        new StringPoolDeserializer(){

            @Override
            protected void deserializeData(DataInputStream din) throws IOException {
                int size = din.readInt();
                for (int i = 0; i < size; ++i) {
                    long hash = din.readLong();
                    int blockCount = din.readByte();
                    ArrayList<String> blockNames = new ArrayList<String>();
                    for (int j = 0; j < blockCount; ++j) {
                        blockNames.add(this.readString(din));
                    }
                    result.add(new SimulinkCloneFragment(uniformPath, parentId, blockNames, hash));
                }
            }
        }.deserialize(data);
        return result;
    }
}

