/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.google.common.collect.Multimap;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.jpountz.xxhash.StreamingXXHash64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkBusElement;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkResolvedInformation;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public abstract class SimulinkResolvedInformationUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimulinkResolvedInformation resolvedInformation;
    private final Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks;
    private final List<SimulinkDataDictionary> dictionaries;
    private boolean blocksUpdated = false;

    protected SimulinkResolvedInformationUpdater(SimulinkResolvedInformation resolvedInformation, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks, List<SimulinkDataDictionary> dictionaries) {
        this.resolvedInformation = resolvedInformation;
        this.typeLinks = typeLinks;
        this.dictionaries = dictionaries;
    }

    protected SimulinkResolvedInformationUpdater(SimulinkResolvedInformation resolvedInformation, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks) {
        this(resolvedInformation, typeLinks, new ArrayList<SimulinkDataDictionary>());
    }

    public boolean hasBeenUpdated() {
        return this.blocksUpdated;
    }

    public void setBlocksUpdated(boolean blockUpdated) {
        this.blocksUpdated = blockUpdated;
    }

    public void updateInformation(SimulinkBlock block, String index, String information) {
        if (this.updateRequiredForBlock(block, index, information)) {
            this.blocksUpdated = true;
            this.resolvedInformation.setOutputInformationForBlock(block, index, information);
        }
        if (!this.typeLinks.containsKey((Object)block)) {
            return;
        }
        List<SimulinkTypeLink> values = SimulinkResolvedInformationUpdater.getTypeLinksForBlockAndIndex(this.typeLinks, block, index);
        for (SimulinkTypeLink value : values) {
            if (!this.updateRequiredForBlock(value.getReceiver(), information)) continue;
            if (value.getReceiver().isOfType("BusSelector") && StringUtils.startsWithIgnoreCase((String)information, (String)"Bus")) {
                this.propagateInformationForBusSelector(value.getReceiver(), information);
                continue;
            }
            if (SimulinkDataTypeUtils.usesInternalRuleInheritance((SimulinkBlock)value.getReceiver())) {
                this.propagateInformationForInternalRuleInheritanceBlock(value.getReceiver(), value);
                continue;
            }
            this.propagateInformation(block, index, information, value);
        }
    }

    protected void propagateInformation(SimulinkBlock block, String index, String information, SimulinkTypeLink link) {
        this.updateInformation(link.getReceiver(), information);
    }

    private static List<SimulinkTypeLink> getTypeLinksForBlockAndIndex(Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks, SimulinkBlock block, String index) {
        ArrayList<SimulinkTypeLink> typeLinksFromIndex = new ArrayList<SimulinkTypeLink>();
        for (SimulinkTypeLink typeLink : typeLinks.get((Object)block)) {
            String senderPortIndex = typeLink.getSenderPortIndex();
            if (senderPortIndex.isEmpty()) {
                senderPortIndex = "1";
            }
            if (!senderPortIndex.equals(index)) continue;
            typeLinksFromIndex.add(typeLink);
        }
        return typeLinksFromIndex;
    }

    public void updateInformation(SimulinkBlock block, String information) {
        if (this.updateRequiredForBlock(block, information)) {
            this.blocksUpdated = true;
            this.resolvedInformation.setOutputInformationForBlock(block, information);
        }
        if (this.typeLinks.containsKey((Object)block)) {
            Collection typeLinksForUpdatedBlock = this.typeLinks.get((Object)block);
            for (SimulinkTypeLink link : typeLinksForUpdatedBlock) {
                if (link.getReceiver().isOfType("BusSelector") && StringUtils.startsWithIgnoreCase((String)information, (String)"Bus")) {
                    this.propagateInformationForBusSelector(link.getReceiver(), information);
                    continue;
                }
                if (SimulinkDataTypeUtils.usesInternalRuleInheritance((SimulinkBlock)link.getReceiver())) {
                    this.propagateInformationForInternalRuleInheritanceBlock(link.getReceiver(), link);
                    continue;
                }
                this.propagateInformation(block, information, link);
            }
        }
    }

    private void propagateInformationForBusSelector(SimulinkBlock block, String busDatatype) {
        if (!block.isOfType("BusSelector")) {
            return;
        }
        List busElements = SimulinkBusUtils.determineAllBusElementsInOutputSignals((SimulinkBlock)block, (String)busDatatype, this.dictionaries);
        for (int i = 0; i < busElements.size(); ++i) {
            Optional busElement = (Optional)busElements.get(i);
            String portIndex = String.valueOf(i + 1);
            if (!busElement.isPresent()) continue;
            this.updateInformation(block, portIndex, ((SimulinkBusElement)busElement.get()).getDataType());
        }
    }

    private void propagateInformationForInternalRuleInheritanceBlock(SimulinkBlock block, SimulinkTypeLink link) {
        Set inputInformation = this.resolvedInformation.getInputInformation(block);
        if (inputInformation.size() < 2) {
            return;
        }
        Optional possibleOutputDataType = SimulinkDataTypeUtils.selectFloatingPointDataTypeWithLargestRange((Set)inputInformation);
        String datatype = "Unknown";
        if (possibleOutputDataType.isPresent()) {
            datatype = (String)possibleOutputDataType.get();
        } else if (block.isOfType("Sum")) {
            datatype = SimulinkDataTypeUtils.determineSumBlockOutputType((Set)inputInformation);
        } else if (block.isOfType("Product")) {
            datatype = SimulinkDataTypeUtils.determineProductBlockOutputType((Set)inputInformation);
        }
        this.propagateInformation(block, datatype, link);
    }

    protected void propagateInformation(SimulinkBlock block, String information, SimulinkTypeLink link) {
        this.updateTypeLink(link, information);
    }

    private boolean updateRequiredForBlock(SimulinkBlock block, String newInformation) {
        Set currentInformation = this.resolvedInformation.getResolvedInformationForAllOutports(block);
        if (currentInformation.isEmpty()) {
            return newInformation != null;
        }
        return this.updateRequired(currentInformation, newInformation);
    }

    private boolean updateRequiredForBlock(SimulinkBlock block, String index, String newInformation) {
        if (this.resolvedInformation.contains(block, index)) {
            String currentInformation = this.resolvedInformation.getResolvedOutputInformationForBlock(block, index);
            if (currentInformation == null) {
                return newInformation != null;
            }
            return this.updateRequired(Set.of(currentInformation), newInformation);
        }
        return true;
    }

    protected abstract boolean updateRequired(Set<String> var1, String var2);

    protected void updateTypeLink(SimulinkTypeLink link, String information) {
        String message = "block " + SimulinkUtils.getFullName((SimulinkBlock)link.getReceiver()) + " gets updated because it depends on block " + SimulinkUtils.getFullName((SimulinkBlock)link.getSender());
        if (link.getReceiverPortIndex().isEmpty()) {
            if (this.updateRequiredForBlock(link.getReceiver(), information)) {
                LOGGER.debug(message);
                this.updateInformation(link.getReceiver(), information);
            }
        } else if (this.updateRequiredForBlock(link.getReceiver(), link.getReceiverPortIndex(), information)) {
            LOGGER.debug(message);
            this.updateInformation(link.getReceiver(), link.getReceiverPortIndex(), information);
        }
    }

    public long calculateResolvedInformationHash() {
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        Map map = this.resolvedInformation.getResolvedInformation();
        for (String key : CollectionUtils.sort(map.keySet())) {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)key);
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)StringUtils.emptyIfNull((String)((String)map.get(key))));
        }
        return hash.getValue();
    }
}

