/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.subsystems;

import com.teamscale.index.simulink.subsystems.SimulinkFileReferenceInfo;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import eu.cqse.check.simulink.simulink.utils.SimulinkPhaseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.jspecify.annotations.Nullable;

@Index(name="simulink-file-reference", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class SimulinkFileReferenceIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "simulink-file-reference";
    private final ValueIndex<SimulinkFileReferenceInfo> delegate;

    public SimulinkFileReferenceIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<SimulinkFileReference> getFileReferences(String uniformPath) throws StorageException {
        SimulinkFileReferenceInfo fileReferenceInfo = (SimulinkFileReferenceInfo)this.delegate.getValue(uniformPath);
        if (fileReferenceInfo == null) {
            return Collections.emptyList();
        }
        return fileReferenceInfo.getFileReferences();
    }

    public List<SimulinkFileReference> getAllFileReferences() throws StorageException {
        ArrayList<SimulinkFileReference> simulinkFileReferences = new ArrayList<SimulinkFileReference>();
        for (SimulinkFileReferenceInfo fileReferenceInfo : this.delegate.getAllEntries().extractSecondList()) {
            simulinkFileReferences.addAll(fileReferenceInfo.getFileReferences());
        }
        return simulinkFileReferences;
    }

    public void removeFileReferences(List<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public void addOrUpdateModel(String uniformPath, @Nullable SimulinkModel model) throws StorageException {
        this.removeFileReferences(List.of(uniformPath));
        if (model == null) {
            return;
        }
        List references = SimulinkPhaseUtils.extractReferencesForModel((SimulinkModel)model);
        this.delegate.setValue(uniformPath, (Object)new SimulinkFileReferenceInfo(references));
    }
}

