/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.DerivedFindingsIndex;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class DerivedFindingsIndexSynchronizerBase
extends ChangeProcessorAnalysisStep {
    public static final String ORIGIN_PARTITION_PROPERTY = "origin-partition";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsIndex findingsIndex;
    @DeltaSource(value=FindingsIndex.class)
    private KeyDelta findingsKeyDelta;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="content")
    private TokenElementIndex previousContentIndex;
    private final Set<String> affectedTargetElements = Collections.synchronizedSet(new HashSet());
    private final Set<String> affectedSourceElementAndPartitions = Collections.synchronizedSet(new HashSet());
    private final ListMap<String, IndexFinding> derivedFindingsByTarget = new ListMap();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private DerivedFindingsIndex derivedFindingsIndex;

    public void execute() throws StorageException, ExecutionException {
        this.handleDeletions();
        ListMap partitionAndUniformPaths = this.findingsIndex.buildPartitionPathMapForRawKeys(this.findingsKeyDelta.getAddedOrChangedKeysAsBytes());
        ArrayList<String> allRelevantUniformPaths = new ArrayList<String>(((List)partitionAndUniformPaths.getValues()).stream().distinct().toList());
        Map contents = CollectionUtils.zipAsMap(allRelevantUniformPaths, this.contentIndex.getTokenElements(allRelevantUniformPaths));
        HashSet<String> pathThatCantBeSourceFiles = new HashSet<String>();
        for (String partition : partitionAndUniformPaths.getKeys()) {
            List pathsInPartition = (List)partitionAndUniformPaths.getCollection((Object)partition);
            for (String uniformPath : pathsInPartition) {
                TokenElementInfo element = (TokenElementInfo)((Object)contents.get(uniformPath));
                if (element != null && this.isPotentialSourceFile(element)) continue;
                pathThatCantBeSourceFiles.add(uniformPath);
            }
            pathsInPartition.removeAll(pathThatCantBeSourceFiles);
        }
        pathThatCantBeSourceFiles.forEach(contents::remove);
        allRelevantUniformPaths.removeAll(pathThatCantBeSourceFiles);
        Map<String, ListMap<String, IndexFinding>> sourcePathToFindings = Collections.synchronizedMap(this.buildSourceToFindingsMap((ListMap<String, String>)partitionAndUniformPaths));
        this.executeInParallelBatches(allRelevantUniformPaths, batch -> this.executeBatch((List<String>)batch, sourcePathToFindings, contents));
        this.updateDerivedFindingsIndex();
    }

    private void executeBatch(List<String> uniformPaths, Map<String, ListMap<String, IndexFinding>> sourcePathToFindings, Map<String, TokenElementInfo> currentElementsMap) throws StorageException {
        this.fillAffectedTargetElements(uniformPaths, currentElementsMap);
        for (String sourcePath : uniformPaths) {
            this.deriveFindings(currentElementsMap.get(sourcePath), sourcePathToFindings.get(sourcePath));
        }
    }

    private void fillAffectedTargetElements(List<String> allSourceUniformPaths, Map<String, TokenElementInfo> contents) throws StorageException {
        for (String uniformPath : allSourceUniformPaths) {
            this.affectedTargetElements.addAll(this.determineTargetElementPaths(contents.get(uniformPath)));
        }
        List<TokenElementInfo> previousContents = this.previousContentIndex.getTokenElements(allSourceUniformPaths, false);
        for (TokenElementInfo previousContent : previousContents) {
            if (previousContent == null) continue;
            this.affectedTargetElements.addAll(this.determineTargetElementPaths(previousContent));
        }
    }

    private Map<String, ListMap<String, IndexFinding>> buildSourceToFindingsMap(ListMap<String, String> partitionAndUniformPaths) throws StorageException {
        HashMap<String, ListMap<String, IndexFinding>> sourcePathToFindings = new HashMap<String, ListMap<String, IndexFinding>>();
        for (String partition : partitionAndUniformPaths.getKeys()) {
            List uniformPaths = (List)partitionAndUniformPaths.getCollection((Object)partition);
            if (uniformPaths.isEmpty()) continue;
            this.affectedSourceElementAndPartitions.addAll(CollectionUtils.map((Collection)uniformPaths, path -> DerivedFindingsIndexSynchronizerBase.makePathWithPartitionKey(path, partition)));
            List findings = this.findingsIndex.getFindings(partition, uniformPaths);
            for (int i = 0; i < uniformPaths.size(); ++i) {
                sourcePathToFindings.computeIfAbsent((String)uniformPaths.get(i), x -> new ListMap()).addAll((Object)partition, (Collection)findings.get(i));
            }
        }
        return sourcePathToFindings;
    }

    private void handleDeletions() throws StorageException {
        if (!this.contentDelta.getDeletedKeys().isEmpty()) {
            this.derivedFindingsIndex.removeFindingsForPartitionsAndPaths(this.getPartition(), this.contentDelta.getDeletedKeysAsStrings());
        }
        ListMap partitionAndUniformPaths = this.findingsIndex.buildPartitionPathMapForRawKeys(this.findingsKeyDelta.getDeletedKeysAsBytes());
        List<String> allRelevantUniformPaths = ((List)partitionAndUniformPaths.getValues()).stream().distinct().toList();
        Map oldContents = CollectionUtils.zipAsMap(allRelevantUniformPaths, this.previousContentIndex.getTokenElements(allRelevantUniformPaths));
        for (String partition : partitionAndUniformPaths.getKeys()) {
            for (String uniformPath : (List)partitionAndUniformPaths.getCollection((Object)partition)) {
                TokenElementInfo element = (TokenElementInfo)((Object)oldContents.get(uniformPath));
                if (element == null || !this.isPotentialSourceFile(element)) continue;
                this.affectedSourceElementAndPartitions.add(DerivedFindingsIndexSynchronizerBase.makePathWithPartitionKey(uniformPath, partition));
                this.affectedTargetElements.addAll(this.determineTargetElementPaths(element));
            }
        }
    }

    private static String makePathWithPartitionKey(String uniformPath, String partition) {
        return uniformPath + "#-#" + partition;
    }

    private void updateDerivedFindingsIndex() throws StorageException {
        ArrayList<String> targetElementPaths = new ArrayList<String>(this.affectedTargetElements);
        List existingFindings = this.derivedFindingsIndex.getFindings(this.getPartition(), targetElementPaths);
        PairList outputFindings = new PairList();
        for (int i = 0; i < targetElementPaths.size(); ++i) {
            ArrayList<IndexFinding> findings = (ArrayList<IndexFinding>)existingFindings.get(i);
            if (findings == null) {
                findings = new ArrayList<IndexFinding>();
            }
            findings.removeIf(this::isDiscardedFinding);
            List addedFindings = (List)this.derivedFindingsByTarget.getCollection((Object)((String)targetElementPaths.get(i)));
            if (!CollectionUtils.isNullOrEmpty((Collection)addedFindings)) {
                findings.addAll(addedFindings);
            }
            findings.sort(Comparator.comparing(DetachedFinding::toString));
            outputFindings.add((Object)((String)targetElementPaths.get(i)), findings);
        }
        this.derivedFindingsIndex.setFindings(this.getPartition(), outputFindings, this.findingsSchemaIndex.getFindingsSchema());
    }

    private boolean isDiscardedFinding(IndexFinding finding) {
        Object originPartition = finding.getProperties().get(ORIGIN_PARTITION_PROPERTY);
        if (finding.getSiblingLocations().isEmpty() || !(originPartition instanceof String)) {
            return true;
        }
        String sourcePath = ((ElementLocation)finding.getSiblingLocations().get(0)).getUniformPath();
        String checkKey = DerivedFindingsIndexSynchronizerBase.makePathWithPartitionKey(sourcePath, (String)originPartition);
        return this.affectedSourceElementAndPartitions.contains(checkKey);
    }

    protected abstract void deriveFindings(TokenElementInfo var1, ListMap<String, IndexFinding> var2) throws StorageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportDerivedFinding(IndexFinding originalFinding, List<ElementLocation> locations, String originPartition) {
        if (locations.isEmpty()) {
            return;
        }
        String uniformPath = locations.get(0).getUniformPath();
        this.affectedTargetElements.add(uniformPath);
        ListMap<String, IndexFinding> listMap = this.derivedFindingsByTarget;
        synchronized (listMap) {
            this.derivedFindingsByTarget.add((Object)uniformPath, (Object)DerivedFindingsIndexSynchronizerBase.createDerivedFinding(originalFinding, locations, originPartition));
        }
    }

    @VisibleForTesting
    public static IndexFinding createDerivedFinding(IndexFinding originalFinding, List<ElementLocation> locations, String originPartition) {
        IndexFinding derivedFinding = new IndexFinding(originalFinding);
        derivedFinding.setMessage("Generated code has: " + originalFinding.getMessage());
        derivedFinding.setLocation(locations.get(0));
        if (locations.size() > 1) {
            derivedFinding.addSecondaryLocations(locations.subList(1, locations.size()));
        }
        derivedFinding.addSiblingLocation(originalFinding.getLocation());
        derivedFinding.setProperty(ORIGIN_PARTITION_PROPERTY, (Object)originPartition);
        return derivedFinding;
    }

    protected abstract List<String> determineTargetElementPaths(TokenElementInfo var1) throws StorageException;

    protected abstract boolean isPotentialSourceFile(TokenElementInfo var1);

    protected abstract String getPartition();
}

