/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace;

import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.stacktrace.component.Stacktrace;
import com.teamscale.index.stacktrace.factory.CsStacktraceParserComponentFactory;
import com.teamscale.index.stacktrace.factory.JavaStacktraceParserComponentFactory;
import com.teamscale.index.stacktrace.factory.StacktraceParserComponentFactory;
import com.teamscale.index.stacktrace.parser.StacktraceParser;
import com.teamscale.index.stacktrace.tokenizer.StacktraceTokenizer;
import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import com.teamscale.index.stacktrace.visitor.UniformPathStacktraceVisitor;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.function.FunctionWithException;

public class StacktraceParserFacade {
    private static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.JAVA, ELanguage.CS);

    public static Stacktrace parseStacktracePlainly(String input) throws StacktraceParser.StacktraceParserException {
        return StacktraceParserFacade.parseStacktrace(input, (FunctionWithException<Stacktrace, Stacktrace, StacktraceParser.StacktraceParserException>)((FunctionWithException)stacktrace -> stacktrace));
    }

    public static Stacktrace parseStacktraceWithUniformPath(String input, PathLookupIndex pathLookupIndex) throws StacktraceParser.StacktraceParserException {
        UniformPathStacktraceVisitor setUniformPathInStacktraceVisitor = new UniformPathStacktraceVisitor(pathLookupIndex);
        return StacktraceParserFacade.parseStacktrace(input, (FunctionWithException<Stacktrace, Stacktrace, StacktraceParser.StacktraceParserException>)((FunctionWithException)stacktrace -> {
            setUniformPathInStacktraceVisitor.visit((Stacktrace)stacktrace);
            return stacktrace;
        }));
    }

    private static Stacktrace parseStacktrace(String input, FunctionWithException<Stacktrace, Stacktrace, StacktraceParser.StacktraceParserException> postProcessing) throws StacktraceParser.StacktraceParserException {
        for (ELanguage language : SUPPORTED_LANGUAGES) {
            try {
                List<IStacktraceToken> tokens;
                StacktraceParserComponentFactory stacktraceParserFactory = StacktraceParserFacade.chooseStacktraceParserFactory(language);
                StacktraceTokenizer tokenizer = stacktraceParserFactory.getTokenizer();
                StacktraceParser parser = stacktraceParserFactory.getParser();
                try {
                    tokens = tokenizer.getTokens(input);
                }
                catch (StacktraceTokenizer.StacktraceTokenizerException e) {
                    StacktraceParser.StacktraceParserException stacktraceParserException = new StacktraceParser.StacktraceParserException("Could not parse the input string: " + input + ".");
                    stacktraceParserException.initCause(e);
                    throw stacktraceParserException;
                }
                Stacktrace result = parser.parse(tokens);
                return (Stacktrace)postProcessing.apply((Object)result);
            }
            catch (StacktraceParser.StacktraceParserException e) {
            }
        }
        throw new StacktraceParser.StacktraceParserException("Stacktraces originating from this language are not yet supported.");
    }

    private static StacktraceParserComponentFactory chooseStacktraceParserFactory(ELanguage language) {
        return switch (language) {
            case ELanguage.JAVA -> new JavaStacktraceParserComponentFactory();
            case ELanguage.CS -> new CsStacktraceParserComponentFactory();
            default -> throw new IllegalArgumentException("No parser for " + String.valueOf(language) + " stacktraces is available.");
        };
    }
}

