/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.parser.util;

import com.teamscale.index.stacktrace.component.ExceptionRepresentation;
import com.teamscale.index.stacktrace.component.Location;
import com.teamscale.index.stacktrace.component.StackFrame;
import com.teamscale.index.stacktrace.tokenizer.EStacktraceTokenType;
import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaCauseExceptionToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaInitialExceptionToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaStackFrameToken;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class JavaStacktraceParserUtils {
    public static ExceptionRepresentation createCauseExceptionFromJavaToken(IStacktraceToken token) {
        CCSMAssert.isTrue((token.getTokenType() == EStacktraceTokenType.JAVA_CAUSE_EXCEPTION ? 1 : 0) != 0, (String)"Expected token of type JAVA_CAUSE_EXCEPTION");
        JavaCauseExceptionToken causeExceptionToken = (JavaCauseExceptionToken)token;
        String exceptionName = causeExceptionToken.getExceptionName();
        String exceptionMessage = causeExceptionToken.getExceptionMessage();
        return ExceptionRepresentation.newCauseException(exceptionName, exceptionMessage);
    }

    public static ExceptionRepresentation createInitialExceptionFromJavaToken(IStacktraceToken token) {
        CCSMAssert.isTrue((token.getTokenType() == EStacktraceTokenType.JAVA_INITIAL_EXCEPTION ? 1 : 0) != 0, (String)"Expected token of type JAVA_INITIAL_EXCEPTION");
        JavaInitialExceptionToken initialExceptionToken = (JavaInitialExceptionToken)token;
        String exceptionMessage = initialExceptionToken.getExceptionMessage();
        String exceptionName = initialExceptionToken.getExceptionName();
        String threadName = initialExceptionToken.getThreadName();
        return ExceptionRepresentation.newInitialException(exceptionName, exceptionMessage, threadName);
    }

    public static StackFrame createStackFrameFromJavaToken(IStacktraceToken token) {
        CCSMAssert.isTrue((token.getTokenType() == EStacktraceTokenType.JAVA_STACK_FRAME ? 1 : 0) != 0, (String)"Expected token of type JAVA_STACK_FRAME");
        JavaStackFrameToken javaStackFrameToken = (JavaStackFrameToken)token;
        String className = javaStackFrameToken.getClassName();
        String methodName = javaStackFrameToken.getMethodName();
        String fileName = javaStackFrameToken.getFileName();
        Integer lineNumber = javaStackFrameToken.getLineNumber();
        if (fileName != null && lineNumber != null) {
            return StackFrame.withLocation(className, methodName, new Location(fileName, lineNumber));
        }
        return StackFrame.withoutLocation(className, methodName);
    }

    private JavaStacktraceParserUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

