/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.saml.SamlAuthenticationOption;
import com.teamscale.core.authenticate.saml.SamlUtils;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.license.License;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.index.system_info.EHealthCheckStatus;
import com.teamscale.index.system_info.JavaSystemInfoFragment;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemInfoIndex;
import com.teamscale.index.system_info.SystemLoadFragment;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.lang.Markdown;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import oshi.SystemInfo;

public enum ESystemHealthCheck {
    SCHEDULER_STATE("Scheduler State"){

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) throws StorageException {
            WorkerIndex workerIndex = (WorkerIndex)indexLayer.openGlobalIndex(WorkerIndex.class);
            ProjectSchedulingFilter projectSchedulingFilter = workerIndex.getSchedulingFilterAccess().get();
            ProjectSchedulingFilter.ESchedulingMode schedulingMode = projectSchedulingFilter.getSchedulingMode();
            if (schedulingMode != ProjectSchedulingFilter.ESchedulingMode.ALL) {
                return ESystemHealthCheck.warn("Scheduling mode: " + String.valueOf(schedulingMode));
            }
            return ESystemHealthCheck.ok("Scheduling mode normal: All jobs are scheduled");
        }
    }
    ,
    SYSTEM_STATE("System State"){

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) throws StorageException {
            CriticalSystemStateIndex.CriticalSystemStatus criticalSystemStatus = ((CriticalSystemStateIndex)indexLayer.openGlobalIndex(CriticalSystemStateIndex.class)).getStatus();
            if (criticalSystemStatus != null) {
                return ESystemHealthCheck.error(criticalSystemStatus.getStatusType().getMessage());
            }
            return ESystemHealthCheck.ok("No critical system event occurred");
        }
    }
    ,
    DISK("Disk"){

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) throws StorageException {
            try {
                PairList<String, Path> pathsToCheck = 3.getPathsToCheck(indexLayer);
                for (Path path : pathsToCheck.extractSecondList()) {
                    if (!3.limitExceeded(1L, path)) continue;
                    return ESystemHealthCheck.error(3.createDiskSpaceLowMessage(1L, path) + ". Scheduling mode was set to maintenance jobs only. Refer to System > Execution status to resume.");
                }
                for (Path path : pathsToCheck.extractSecondList()) {
                    if (!3.limitExceeded(2L, path)) continue;
                    return ESystemHealthCheck.warn(3.createDiskSpaceLowMessage(2L, path));
                }
                Optional storageDirectory = indexLayer.getStorageDirectory();
                if (storageDirectory.isPresent()) {
                    return 3.checkStoragePath(indexLayer, ((File)storageDirectory.get()).toPath());
                }
                return 3.diskSpaceOk();
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        private static String createDiskSpaceLowMessage(long criticalDiskLevelGigabytes, Path path) {
            return "Disk space for directory " + String.valueOf(path) + " is below " + criticalDiskLevelGigabytes + " GB";
        }

        private static boolean limitExceeded(long criticalDiskLevelGigabytes, Path path) throws IOException {
            return Files.exists(path, new LinkOption[0]) && Files.exists(path.toRealPath(new LinkOption[0]), new LinkOption[0]) && Files.getFileStore(path.toRealPath(new LinkOption[0])).getUsableSpace() < criticalDiskLevelGigabytes * 0x40000000L;
        }

        private static CheckResult checkStoragePath(IndexLayer indexLayer, Path storagePath) throws IOException, StorageException {
            SystemInfoIndex systemInfoIndex = (SystemInfoIndex)indexLayer.openGlobalIndex(SystemInfoIndex.class);
            Optional<SystemInfoFragmentBase> systemLoadFragment = systemInfoIndex.getAllValidFragments().stream().filter(fragment -> fragment instanceof SystemLoadFragment).findFirst();
            if (systemLoadFragment.isPresent()) {
                long storageDirectorySize = ((SystemLoadFragment)CCSMAssert.checkedCast((Object)systemLoadFragment.get(), SystemLoadFragment.class)).getStorageDirectorySize();
                long criticalThreshold = ByteUnit.BYTES.toGibiBytes(storageDirectorySize * 5L / 100L);
                if (3.limitExceeded(criticalThreshold, storagePath)) {
                    return ESystemHealthCheck.error(3.createDiskSpaceLowMessage(criticalThreshold, storagePath));
                }
                long warningThreshold = ByteUnit.BYTES.toGibiBytes(storageDirectorySize * 10L / 100L);
                if (3.limitExceeded(warningThreshold, storagePath)) {
                    return ESystemHealthCheck.warn(3.createDiskSpaceLowMessage(warningThreshold, storagePath));
                }
            } else {
                LOGGER.error("No SystemLoadFragment found in system info index");
            }
            return 3.diskSpaceOk();
        }

        private static @NonNull CheckResult diskSpaceOk() {
            return ESystemHealthCheck.ok("Disk space is ok");
        }
    }
    ,
    MEMORY_SETTINGS("Memory Settings"){
        @Markdown
        private static final String MESSAGE_OK = "Memory settings are ok";

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) {
            if (EFeatureToggle.DISABLE_MEMORY_CHECK.isEnabled()) {
                return ESystemHealthCheck.ok(MESSAGE_OK);
            }
            JavaSystemInfoFragment javaSystemInfoFragment = new JavaSystemInfoFragment();
            SystemInfo systemInfo = new SystemInfo();
            long ramAvailableMb = SystemLoadFragment.getRamAvailableMB(systemInfo);
            long memoryAllocatableByJvm = javaSystemInfoFragment.getMaxMemory() - javaSystemInfoFragment.getTotalMemory();
            if (memoryAllocatableByJvm > ramAvailableMb) {
                return ESystemHealthCheck.warn("Current JVM configuration (-Xmx) might lead to an Out of Memory error. Decrease the configured heap size or increase the available RAM.");
            }
            return ESystemHealthCheck.ok(MESSAGE_OK);
        }
    }
    ,
    LICENSE("License"){

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) {
            License license = LicenseManager.getInstance().getLicense();
            if (license == null) {
                return ESystemHealthCheck.error("No valid license found!");
            }
            LocalDate today = (LocalDate)DateTimeUtils.withClock(LocalDate::now);
            if (today.isAfter(license.getValidTo())) {
                return ESystemHealthCheck.error("License expired!");
            }
            if (license.getExpiresSoon()) {
                return ESystemHealthCheck.warn("License will expire in less than " + (license.daysLeft() + 1L) + " days");
            }
            return ESystemHealthCheck.ok("Valid license found with " + license.daysLeft() + " days left");
        }
    }
    ,
    SERVER_CERTIFICATE("Server Certificate"){

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) throws StorageException {
            Optional serverCertificateValidDate = indexLayer.openMetaIndex().getLongValue(ESystemHealthCheck.SERVER_CERTIFICATE_VALID_DATE_META_INDEX_KEY);
            if (serverCertificateValidDate.isPresent()) {
                long validDays = DateTimeUtils.diff((Instant)DateTimeUtils.now(), (Instant)DateTimeUtils.atZone((long)((Long)serverCertificateValidDate.get())).toInstant(), (TimeUnit)TimeUnit.DAYS);
                if (validDays <= 30L) {
                    return ESystemHealthCheck.error(ESystemHealthCheck.createServerCertificateExpirationMessage(validDays));
                }
                if (validDays <= 60L) {
                    return ESystemHealthCheck.warn(ESystemHealthCheck.createServerCertificateExpirationMessage(validDays));
                }
                return ESystemHealthCheck.ok("Server certificate valid for " + validDays + " days");
            }
            return ESystemHealthCheck.ok("No server certificate available (HTTP mode)");
        }
    }
    ,
    SAML_CERTIFICATES("SAML Certificates"){
        private static final Duration WARNING_LIMIT = Duration.ofDays(30L);

        @Override
        public CheckResult performCheck(IndexLayer indexLayer) throws StorageException {
            Map<String, SamlAuthenticationOption> samlOptions = 7.getSamlAuthenticationOptions(indexLayer);
            if (samlOptions.isEmpty()) {
                return ESystemHealthCheck.ok("No SAML Identity Provider available");
            }
            EHealthCheckStatus combinedHealthStatus = EHealthCheckStatus.OK;
            ArrayList<CallSite> messages = new ArrayList<CallSite>();
            for (String samlOptionName : CollectionUtils.sort(samlOptions.keySet())) {
                SamlAuthenticationOption samlOption = samlOptions.get(samlOptionName);
                Pair<EHealthCheckStatus, String> samlCheckResult = 7.performCheckForSamlCertificate(samlOption);
                EHealthCheckStatus samlCheckStatus = (EHealthCheckStatus)((Object)samlCheckResult.getFirst());
                if (samlCheckStatus.compareTo(combinedHealthStatus) > 0) {
                    combinedHealthStatus = samlCheckStatus;
                }
                messages.add((CallSite)((Object)(StringUtils.stripPrefix((String)samlOptionName, (String)"/") + ": " + (String)samlCheckResult.getSecond())));
            }
            return new CheckResult(combinedHealthStatus, String.join((CharSequence)"; ", messages));
        }

        private static Map<String, SamlAuthenticationOption> getSamlAuthenticationOptions(IndexLayer indexLayer) throws StorageException {
            ServerOptionIndex serverOptionIndex = (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class);
            String optionNamePrefix = ESsoAuthenticatorType.SAML.getOptionId();
            Map options = ServerOptionRegistry.getInstance().getServerOptions(optionNamePrefix, serverOptionIndex);
            HashMap<String, SamlAuthenticationOption> samlOptions = new HashMap<String, SamlAuthenticationOption>();
            for (Map.Entry optionEntry : options.entrySet()) {
                Object v = optionEntry.getValue();
                if (!(v instanceof SamlAuthenticationOption)) continue;
                SamlAuthenticationOption samlAuthenticationOption = (SamlAuthenticationOption)v;
                if (((String)optionEntry.getKey()).equals(optionNamePrefix)) continue;
                samlOptions.put((String)optionEntry.getKey(), samlAuthenticationOption);
            }
            return samlOptions;
        }

        private static Pair<EHealthCheckStatus, String> performCheckForSamlCertificate(SamlAuthenticationOption samlOption) {
            Optional<X509Certificate> x509Certificate = samlOption.getCertificate().map(SamlUtils::parseCertificateFromBytes);
            if (x509Certificate.isEmpty()) {
                return new Pair((Object)EHealthCheckStatus.OK, (Object)"no certificate available");
            }
            Instant certificateValidEnd = x509Certificate.get().getNotAfter().toInstant();
            Duration remainingDuration = Duration.between(DateTimeUtils.now(), certificateValidEnd);
            if (remainingDuration.isNegative()) {
                return new Pair((Object)EHealthCheckStatus.CRITICAL, (Object)("certificate expired " + 7.remainingTime(remainingDuration.abs()) + " ago"));
            }
            String message = "certificate will expire in " + 7.remainingTime(remainingDuration);
            EHealthCheckStatus status = EHealthCheckStatus.OK;
            if (remainingDuration.compareTo(WARNING_LIMIT) < 0) {
                status = EHealthCheckStatus.WARNING;
            }
            return new Pair((Object)status, (Object)message);
        }

        private static @NonNull String remainingTime(Duration remainingDuration) {
            if (remainingDuration.toHours() == 0L) {
                return remainingDuration.toMinutes() + " minutes";
            }
            if (remainingDuration.toDays() == 0L) {
                return remainingDuration.toHours() + " hours";
            }
            return remainingDuration.toDays() + " days";
        }
    };

    private static final Logger LOGGER;
    private static final long CRITICAL_DISK_LEVEL_GIGABYTES = 1L;
    private static final long WARNING_DISK_LEVEL_GIGABYTES = 2L;
    private static final long CRITICAL_DISK_LEVEL_PERCENTAGE = 5L;
    private static final long WARNING_DISK_LEVEL_PERCENTAGE = 10L;
    public static final String SERVER_CERTIFICATE_VALID_DATE_META_INDEX_KEY = "server-certificate-valid-date";
    private final String readableName;

    private static String createServerCertificateExpirationMessage(long validDays) {
        return "Server certificate expires in " + validDays + " days";
    }

    private ESystemHealthCheck(String readableName) {
        this.readableName = readableName;
    }

    public String getReadableName() {
        return this.readableName;
    }

    public abstract CheckResult performCheck(IndexLayer var1) throws StorageException;

    private static CheckResult error(@Markdown String message) {
        return new CheckResult(EHealthCheckStatus.CRITICAL, message);
    }

    private static CheckResult warn(@Markdown String message) {
        return new CheckResult(EHealthCheckStatus.WARNING, message);
    }

    private static CheckResult ok(@Markdown String message) {
        return new CheckResult(EHealthCheckStatus.OK, message);
    }

    public static PairList<String, Path> getPathsToCheck(IndexLayer indexLayer) throws StorageException {
        PairList pathsToCheck = new PairList();
        pathsToCheck.add((Object)"working", (Object)FileSystemUtils.getJvmWorkingDirOrTempForDevMode().toPath());
        TeamscaleInstallationUtils.getInstallationDirectory().ifPresent(directory -> pathsToCheck.add((Object)"installation", directory));
        indexLayer.getStorageDirectory().ifPresent(directory -> pathsToCheck.add((Object)"storage", (Object)directory.toPath()));
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class);
        pathsToCheck.add((Object)"repositories", (Object)RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)serverOptionIndex));
        pathsToCheck.add((Object)"temp", (Object)FileSystemUtils.getTmpDir().toPath());
        return pathsToCheck;
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    public record CheckResult(EHealthCheckStatus status, @Markdown String message) {
        public CheckResult {
            Objects.requireNonNull(status, "status");
            Objects.requireNonNull(message, "message");
        }
    }
}

