/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemLoadFragment;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.util.StorageAbbreviator;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class StorageAbbreviatorStatisticsFragment
extends SystemInfoFragmentBase {
    private static final long serialVersionUID = 1L;

    public StorageAbbreviatorStatisticsFragment(long updateInterval) {
        super(updateInterval);
    }

    @Override
    public String getFragmentCaption() {
        return "Internal String Abbreviator Cache Statistics";
    }

    @Override
    public List<SystemInfoEntry> convertToKeyValuePairs() {
        ArrayList<SystemInfoEntry> result = new ArrayList<SystemInfoEntry>();
        result.add(SystemInfoEntry.ofString("Cache Hits", String.valueOf(StorageAbbreviator.getCacheHits())));
        result.add(SystemInfoEntry.ofString("Cache Misses", String.valueOf(StorageAbbreviator.getCacheMisses())));
        double cacheHitsPercentage = (double)StorageAbbreviator.getCacheHits() / (double)(StorageAbbreviator.getCacheMisses() + StorageAbbreviator.getCacheHits()) * 100.0;
        result.add(SystemInfoEntry.ofPercentage("Cache Hit %:", cacheHitsPercentage));
        long estimatedCacheSizeInBytes = StorageAbbreviator.getEstimatedCacheSizeInBytes();
        result.add(SystemInfoEntry.ofString("Cache Estimated Size", SystemLoadFragment.convertToMB(estimatedCacheSizeInBytes, ByteUnit.BYTES)));
        long maximumCacheSizeInBytes = StorageAbbreviator.MAXIMUM_CACHE_SIZE_BYTES;
        result.add(SystemInfoEntry.ofString("Max Configured Size", SystemLoadFragment.convertToMB(maximumCacheSizeInBytes, ByteUnit.BYTES)));
        return result;
    }
}

