/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.monitoring.OperationMonitor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class StorageSystemPerformanceInfoFragment
extends SystemInfoFragmentBase {
    private static final long serialVersionUID = 1L;
    public static final long UPDATE_INTERVAL_MILLIS = 5000L;
    private final List<OperationMonitor.OperationRates> rates;

    public StorageSystemPerformanceInfoFragment(List<OperationMonitor.OperationRates> rates) {
        super(5000L);
        this.rates = rates;
    }

    @Override
    public String getFragmentCaption() {
        return "Storage System Performance";
    }

    @Override
    public List<SystemInfoEntry> convertToKeyValuePairs() {
        ArrayList<SystemInfoEntry> result = new ArrayList<SystemInfoEntry>();
        for (OperationMonitor.OperationRates rate : this.rates) {
            result.add(SystemInfoEntry.ofString(rate.getName() + " operations per second", SystemInfoEntry.format(rate.getOperationsPerSecond())));
            result.add(SystemInfoEntry.ofString(rate.getName() + " keys per second", SystemInfoEntry.format(rate.getKeysPerSecond())));
            result.add(SystemInfoEntry.ofString(rate.getName() + " average operation time (ms)", SystemInfoEntry.format(rate.getAverageOperationSeconds() * 1000.0)));
        }
        return result;
    }
}

