/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.utils.MarkdownUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import org.conqat.lib.commons.lang.Markdown;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SystemInfoEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final NumberFormat FORMAT = SystemInfoEntry.buildNumberFormat();
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="value")
    private final SystemInfoEntryValue value;

    private static NumberFormat buildNumberFormat() {
        NumberFormat format = NumberFormat.getInstance(Locale.US);
        format.setMaximumFractionDigits(1);
        format.setMinimumFractionDigits(0);
        return format;
    }

    private SystemInfoEntry(String name, SystemInfoEntryValue value) {
        this.name = Objects.requireNonNull(name, "name");
        this.value = Objects.requireNonNull(value, "value");
    }

    public static SystemInfoEntry ofString(String name, String value) {
        return new SystemInfoEntry(name, new SystemInfoEntryValue.StringValue(value));
    }

    public static SystemInfoEntry ofMarkdown(String name, @Markdown String markdown) {
        return new SystemInfoEntry(name, new SystemInfoEntryValue.MarkdownValue(markdown));
    }

    public static SystemInfoEntry ofPercentage(String name, double percentage) {
        return new SystemInfoEntry(name, new SystemInfoEntryValue.PercentageValue(percentage, SystemInfoEntry.formatPercentage(percentage)));
    }

    public static SystemInfoEntry ofPercentage(String name, double percentage, String description) {
        return new SystemInfoEntry(name, new SystemInfoEntryValue.PercentageValue(percentage, description + " (" + SystemInfoEntry.formatPercentage(percentage) + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(double value) {
        NumberFormat numberFormat = FORMAT;
        synchronized (numberFormat) {
            return FORMAT.format(value);
        }
    }

    private static String formatPercentage(double percentage) {
        if (Double.isNaN(percentage)) {
            return "-";
        }
        return SystemInfoEntry.format(percentage) + " %";
    }

    public String getName() {
        return this.name;
    }

    public SystemInfoEntryValue getValue() {
        return this.value;
    }

    @Schema(oneOf={StringValue.class, MarkdownValue.class, PercentageValue.class})
    @IndexValueClass
    public static sealed interface SystemInfoEntryValue
    extends Serializable {

        @IndexValueClass
        public record PercentageValue(double percentage, String description) implements SystemInfoEntryValue
        {
            public PercentageValue {
                Objects.requireNonNull(description, "description");
            }

            @Override
            public String toString() {
                return this.description;
            }
        }

        @IndexValueClass
        public record MarkdownValue(@Markdown String markdown) implements SystemInfoEntryValue
        {
            public MarkdownValue {
                Objects.requireNonNull(markdown, "markdown");
            }

            @Override
            public String toString() {
                return MarkdownUtils.translateMarkdownToText((String)this.markdown);
            }
        }

        @IndexValueClass
        public record StringValue(String string) implements SystemInfoEntryValue
        {
            public StringValue {
                Objects.requireNonNull(string, "string");
            }

            @Override
            public String toString() {
                return this.string;
            }
        }
    }
}

