/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.EStartableComponent;
import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.config.DistributionConfiguration;
import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.VersionUtil;
import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemLoadFragment;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TeamscaleSystemInfoFragment
extends SystemInfoFragmentBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<SystemInfoEntry> entries = new ArrayList<SystemInfoEntry>();

    public TeamscaleSystemInfoFragment(ServerConfiguration configuration, IndexLayer indexLayer) throws StorageException {
        super(Long.MAX_VALUE);
        this.entries.add(SystemInfoEntry.ofString("Version", VersionUtil.readTeamscaleVersionDetails()));
        this.entries.add(SystemInfoEntry.ofString("Started components", Stream.of(EStartableComponent.values()).filter(EStartableComponent::isEnabled).map(component -> StringUtils.toFirstUpper((String)component.name().replace('_', ' '))).collect(Collectors.joining(", "))));
        this.addDatabaseConfiguration(configuration.getDatabaseConfiguration());
        this.addDistributionLayerConfiguration(configuration.getDistributionConfiguration());
        this.addInstallationDetails(indexLayer.openGlobalStorageSystem());
        this.addWorkerConfiguration(configuration);
        this.addServiceLayerConfiguration(configuration, indexLayer);
    }

    private void addDatabaseConfiguration(DatabaseConfiguration configuration) {
        this.addNonEmpty("Database", StringUtils.toFirstUpper((String)configuration.getDatabaseType().name()));
        if (configuration.getDatabaseType().isLocalDiskBased()) {
            this.addNonEmpty("Database cache", SystemLoadFragment.convertToMB(configuration.getCacheSizeMB(), ByteUnit.MEBIBYTES));
            this.addNonEmpty("Database directory", configuration.getStorageDirectory().getAbsolutePath());
        }
    }

    private void addDistributionLayerConfiguration(DistributionConfiguration configuration) {
        if (configuration.getLayer() == DistributionConfiguration.EDistributionLayer.LOCAL) {
            return;
        }
        this.addNonEmpty("Distribution layer", StringUtils.toFirstUpper((String)configuration.getLayer().name()));
    }

    private void addWorkerConfiguration(ServerConfiguration configuration) {
        if (EStartableComponent.WORKER.isEnabled()) {
            this.entries.add(SystemInfoEntry.ofString("Worker count", String.valueOf(configuration.getNumWorkers())));
        }
    }

    private void addInstallationDetails(GlobalStorageSystem globalStorageSystem) {
        Optional<String> installationDirectory = TeamscaleInstallationUtils.getInstallationDirectory().map(path -> path.toAbsolutePath().toString());
        this.addNonEmpty("Installation directory", installationDirectory.orElse("not specified"));
        this.addCheckLocations();
        this.addCheckCounts(globalStorageSystem);
    }

    private void addCheckLocations() {
        ListMap checksPerLocation = CheckRegistry.getInstance().getCustomChecksPerLocation();
        if (checksPerLocation.isEmpty()) {
            return;
        }
        this.entries.add(SystemInfoEntry.ofMarkdown("Custom checks", checksPerLocation.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + " (" + ((List)entry.getValue()).size() + " checks)").map(StringUtils::escapeMarkdownChars).map(s -> "* " + s).collect(Collectors.joining("\n"))));
    }

    private void addCheckCounts(GlobalStorageSystem globalStorageSystem) {
        ConfigurationTemplateManager allDescriptors;
        try {
            allDescriptors = ConfigRegistry.getInstance().initializeConfigurationTemplateManager(CodeScopeAware.from((CodeScopeName)CodeScopeAware.DEFAULT_CODE_SCOPE, Set.of(ELanguage.values())), CodeScopeAware.from((CodeScopeName)CodeScopeAware.DEFAULT_CODE_SCOPE, Set.of(EAnalysisTool.values())), List.of(CodeScopeAware.DEFAULT_CODE_SCOPE), globalStorageSystem);
        }
        catch (ProjectConfigurationException e) {
            LOGGER.error("Error determining number of checks: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        int internalChecks = 0;
        int externalChecks = 0;
        int ownChecks = 0;
        List descriptors = allDescriptors.getAllConfigurations().values().stream().flatMap(config -> config.getProvidedFindings(CodeScopeAware.DEFAULT_CODE_SCOPE).stream()).toList();
        for (FindingDescriptor findingDescriptor : descriptors) {
            if (findingDescriptor.getTool().isInternal()) {
                ++internalChecks;
            } else {
                ++externalChecks;
            }
            if (findingDescriptor.getTool() != EAnalysisTool.TEAMSCALE) continue;
            ++ownChecks;
        }
        this.addNonEmpty("Internal Checks", internalChecks + " (" + ownChecks + " core checks)");
        this.addNonEmpty("External Checks", String.valueOf(externalChecks));
    }

    private void addServiceLayerConfiguration(ServerConfiguration configuration, IndexLayer indexLayer) {
        if (!EStartableComponent.SERVICE_SERVER.isEnabled()) {
            return;
        }
        this.addNonEmpty("Bind hostname", configuration.getBindHostname());
        this.addNonEmpty("URL prefix", configuration.getUrlPrefix());
        if (configuration.isHttpConfigured()) {
            this.addNonEmpty("HTTP port", Integer.toString(configuration.getHttpPort()));
        } else {
            this.addNonEmpty("HTTP port", "disabled");
        }
        if (configuration.isHttpsConfigured()) {
            this.addNonEmpty("HTTPS port", Integer.toString(configuration.getHttpsPort()));
            this.addNonEmpty("HTTPS keystore path", configuration.getKeyStorePath());
            this.addHttpsCertificateInformation(configuration, indexLayer);
        }
        this.addNonEmpty("Service log level", StringUtils.toFirstUpper((String)configuration.getServiceLogLevel().name()));
        this.addNonEmpty("User-level logging", Boolean.toString(configuration.isServiceLogIncludeUsers()));
    }

    private void addHttpsCertificateInformation(ServerConfiguration configuration, IndexLayer indexLayer) {
        String certificateInfo = "Alias: " + configuration.getCertificateAlias();
        try {
            KeyStore keyStore = configuration.loadHttpsKeyStore();
            Certificate certificate = keyStore.getCertificate(configuration.getCertificateAlias());
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                certificateInfo = certificateInfo + ", issued to: " + x509Certificate.getSubjectX500Principal().getName();
                Date notAfter = x509Certificate.getNotAfter();
                certificateInfo = certificateInfo + ", valid until: " + DateTimeUtils.getUiFormattedDateString((long)notAfter.getTime());
                indexLayer.openMetaIndex().setLongValue("server-certificate-valid-date", notAfter.getTime());
            } else {
                LOGGER.warn("Unexpected type of certificate: {}", certificate.getClass());
            }
        }
        catch (IOException | KeyStoreException | StorageException e) {
            LOGGER.error("Error loading server certificate: {}", (Object)e.getMessage(), (Object)e);
        }
        this.addNonEmpty("HTTPS certificate", certificateInfo);
    }

    private void addNonEmpty(String name, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            this.entries.add(SystemInfoEntry.ofString(name, value));
        }
    }

    @Override
    public String getFragmentCaption() {
        return "Teamscale Version and Configuration";
    }

    @Override
    public int getFragmentOrder() {
        return 2;
    }

    @Override
    public List<SystemInfoEntry> convertToKeyValuePairs() {
        ArrayList<SystemInfoEntry> result = new ArrayList<SystemInfoEntry>(this.entries);
        result.add(1, SystemInfoEntry.ofString("Uptime", TeamscaleSystemInfoFragment.formatDuration(Duration.between(this.getCreatedAt(), DateTimeUtils.now()))));
        return result;
    }

    private static String formatDuration(Duration duration) {
        long hours;
        StringBuilder result = new StringBuilder();
        long days = duration.toDaysPart();
        if (days > 0L) {
            result.append(days).append(" days ");
        }
        if ((hours = (long)duration.toHoursPart()) > 0L) {
            result.append(hours).append(" hours ");
        }
        long minutes = duration.toMinutesPart();
        result.append(minutes).append(" minutes ");
        return result.toString();
    }
}

