/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeScopePathDataRetriever
implements ITgaDataRetriever {
    private final UniformPath uniformPath;
    private final List<String> partitions;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final CrossAnnotator crossAnnotator;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public CodeScopePathDataRetriever(UniformPath uniformPath, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.uniformPath = uniformPath;
        this.partitions = partitions;
        this.crossAnnotator = crossAnnotator;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        Optional codeScopeName = this.uniformPath.getCodeScope();
        if (codeScopeName.isPresent() && !((Boolean)this.tgaEnablementPerCodeScope.getValue((CodeScopeName)codeScopeName.get())).booleanValue()) {
            return new UnassessedTestGapData();
        }
        UnassessedTestGapData codeScopeUnawareData = this.fetchDataCodeScopeUnaware(methodInfoFilter);
        return this.filterAndConvertUniformPathsToCodeScopePaths(codeScopeUnawareData);
    }

    private UnassessedTestGapData fetchDataCodeScopeUnaware(MethodInfoFilter methodInfoFilter) throws StorageException {
        UniformPath codeScopeUnawarePath = this.uniformPath.resolveToCodePath();
        List<AssociatedMethodInfo> methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getMethodInfosForPathPrefix(codeScopeUnawarePath);
        return DataRetrieverUtils.createUnassessedTestGapData(methodInfos, this.partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
    }

    private UnassessedTestGapData filterAndConvertUniformPathsToCodeScopePaths(UnassessedTestGapData codeScopeUnawareData) throws StorageException {
        Map<UniformPath, CodeScopeName> codeScopeMappings = this.dataRetrieverIndexes.getCodeScopesMappingIndex().getAllMappings();
        Optional originalCodeScopeName = this.uniformPath.getCodeScope();
        ArrayList<UnassessedTestGapData.UnassessedMethodData> filteredAndTranslatedMethods = new ArrayList<UnassessedTestGapData.UnassessedMethodData>();
        for (UnassessedTestGapData.UnassessedMethodData method : codeScopeUnawareData.getMethods()) {
            UniformPath uniformPath = method.getLocation().getUniformPath();
            CodeScopeName codeScopeOfMethod = codeScopeMappings.get(uniformPath);
            if (codeScopeOfMethod == null || originalCodeScopeName.isPresent() && !((CodeScopeName)originalCodeScopeName.get()).equals((Object)codeScopeOfMethod)) continue;
            filteredAndTranslatedMethods.add(method.withUniformPath((UniformPath)uniformPath.asCodeScopePath(codeScopeOfMethod)));
        }
        return new UnassessedTestGapData(filteredAndTranslatedMethods);
    }
}

