/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.base.MergeCommitAnalysisStepBase;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.TestDeltaCalculator;
import com.teamscale.index.tests.TestExecutionDeltaIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.jetbrains.annotations.VisibleForTesting;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestExecutionMerger
extends MergeCommitAnalysisStepBase {
    private static final int EXECUTIONS_MERGE_BATCH_SIZE = 100;
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestExecutionIndex testExecutionIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<TestExecutionIndex> parentTestExecutionIndices;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExecutionUnitIndex executionUnitIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<ExecutionUnitIndex> parentExecutionUnitIndices;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestExecutionDeltaIndex testExecutionDeltaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CommitDescriptorIndex commitDescriptorIndex;

    @Override
    public void processMergeCommit() throws StorageException, ExecutionException {
        Set<PartitionAndPath> affectedTests;
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        try {
            affectedTests = TestExecutionMerger.collectAffectedTests(schedulingCommit, this.testExecutionDeltaIndex, this.commitDescriptorIndex);
        }
        catch (CommitResolutionException e) {
            LOGGER.error("Failed to collect affected tests.", (Throwable)e);
            return;
        }
        this.testExecutionDeltaIndex.insertOrMerge(schedulingCommit, affectedTests);
        List mergedTestExecutionPaths = Collections.synchronizedList(Lists.newArrayList());
        List mergedTestExecutionUnitPaths = Collections.synchronizedList(Lists.newArrayList());
        this.executeInParallelBatches(new ArrayList<PartitionAndPath>(affectedTests), affectedTestsChunk -> {
            PairList<PartitionAndPath, TestExecutionWithPartition> mergedExecutions = TestExecutionMerger.mergeTestExecutions(this.parentTestExecutionIndices, affectedTestsChunk, this::mergeTests, TestExecutionIndex::getTestExecutionsForPartitionAndPaths);
            mergedTestExecutionPaths.addAll(mergedExecutions.getFirstList());
            this.testExecutionIndex.setTestExecutions(mergedExecutions);
            PairList<PartitionAndPath, ExecutionUnit> mergedExecutionUnits = TestExecutionMerger.mergeTestExecutions(this.parentExecutionUnitIndices, affectedTestsChunk, ExecutionUnit::merge, ExecutionUnitIndex::getExecutionUnits);
            mergedTestExecutionUnitPaths.addAll(mergedExecutionUnits.getFirstList());
            this.executionUnitIndex.setExecutionUnits(mergedExecutionUnits);
        }, 100);
        this.testExecutionIndex.addMergedFromOtherBranchesFor(mergedTestExecutionPaths, schedulingCommit);
        this.executionUnitIndex.addMergedFromOtherBranchesFor(mergedTestExecutionUnitPaths, schedulingCommit);
    }

    private TestExecutionWithPartition mergeTests(List<TestExecutionWithPartition> tests) {
        return TestExecutionWithPartition.merge(this.getSchedulingCommit(), tests);
    }

    @VisibleForTesting
    static <T extends Serializable, Index extends PartitionIndexBase> PairList<PartitionAndPath, T> mergeTestExecutions(List<Index> parentTestExecutionIndices, List<PartitionAndPath> affectedTests, Function<List<T>, T> mergeFunction, BiFunctionWithException<Index, List<PartitionAndPath>, List<T>, StorageException> valueAccessor) throws StorageException {
        Preconditions.checkState((parentTestExecutionIndices.size() > 1 ? 1 : 0) != 0, (Object)"Expecting more than two parent indexes for merge commit.");
        ListMap<PartitionAndPath, T> allParentPathsAndTests = TestExecutionMerger.getTestExecutionsByPartitionAndPath(parentTestExecutionIndices, affectedTests, valueAccessor);
        PairList values = new PairList();
        for (PartitionAndPath partitionAndPath : allParentPathsAndTests.getKeys()) {
            List testExecutionWithPartitions = (List)allParentPathsAndTests.getCollection((Object)partitionAndPath);
            Serializable mergedExecution = (Serializable)mergeFunction.apply(testExecutionWithPartitions);
            values.add((Object)partitionAndPath, (Object)mergedExecution);
        }
        return values;
    }

    private static <T extends Serializable, Index extends PartitionIndexBase> ListMap<PartitionAndPath, T> getTestExecutionsByPartitionAndPath(List<Index> parentTestExecutionIndices, List<PartitionAndPath> affectedTests, BiFunctionWithException<Index, List<PartitionAndPath>, List<T>, StorageException> valueAccessor) throws StorageException {
        ListMap allParentPathsAndTests = new ListMap();
        for (PartitionIndexBase parentTestExecutionIndex : parentTestExecutionIndices) {
            List testExecutions = (List)valueAccessor.apply((Object)parentTestExecutionIndex, affectedTests);
            CollectionUtils.forEach(affectedTests, (Iterable)testExecutions, (test, testExecution) -> {
                if (testExecution != null) {
                    allParentPathsAndTests.add(test, testExecution);
                }
            });
        }
        return allParentPathsAndTests;
    }

    @VisibleForTesting
    static Set<PartitionAndPath> collectAffectedTests(CommitDescriptor schedulingCommit, TestExecutionDeltaIndex testExecutionDeltaIndex, CommitDescriptorIndex commitDescriptorIndex) throws StorageException, CommitResolutionException {
        List<CommitDescriptor> unmergedCommits = TestDeltaCalculator.getUnmergedCommits(schedulingCommit, commitDescriptorIndex);
        LOGGER.info("Processing {} unmerged commits.", (Object)unmergedCommits.size());
        HashSet<PartitionAndPath> affectedTests = new HashSet<PartitionAndPath>();
        for (List commitChunk : Lists.partition(unmergedCommits, (int)500)) {
            List testExecutionDeltas = testExecutionDeltaIndex.getEntries(commitChunk);
            for (TestExecutionDeltaIndex.TestExecutionDelta testExecutionDelta : testExecutionDeltas) {
                if (testExecutionDelta == null) continue;
                affectedTests.addAll((Collection<PartitionAndPath>)testExecutionDelta.getAffectedTests());
            }
        }
        LOGGER.info("{} tests need to be merged.", (Object)affectedTests.size());
        return affectedTests;
    }
}

