/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.index.testimpact.TestHistorySynchronizer;
import com.teamscale.index.testimpact.TestLinks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Index(name="test-links", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class TestLinksIndex
implements IProjectIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "test-links";
    private final ValueIndex<TestLinks> delegate;

    public TestLinksIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void addNewTestImplementationsWithoutExecution(List<String> uniformPathsAndTestImplementations) throws StorageException {
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Adding test implementation to test link index for: " + String.valueOf(uniformPathsAndTestImplementations));
        PairList testLinks = (PairList)uniformPathsAndTestImplementations.stream().map(key -> new Pair(key, (Object)new TestLinks((String)key, Set.of()))).collect(PairList.toPairList());
        this.delegate.setValues(testLinks);
    }

    public void addTestExecutions(PairList<UniformPath, TestLinks> testExecutionsWithLinks) throws StorageException {
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Adding test executions to test link index for: " + String.valueOf(testExecutionsWithLinks));
        PairList values = new PairList();
        for (int i = 0; i < testExecutionsWithLinks.size(); ++i) {
            values.add((Object)((UniformPath)testExecutionsWithLinks.getFirst(i)).toString(), (Object)((TestLinks)testExecutionsWithLinks.getSecond(i)));
        }
        this.delegate.setOrMergeValues(values, TestLinks::merge);
    }

    public void removeTestImplementations(Collection<String> deletedTests) throws StorageException {
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Removing test implementations from test link index for: " + String.valueOf(deletedTests));
        this.delegate.removeValues(deletedTests);
    }

    public PairList<String, @Nullable String> removeTestExecutions(List<PartitionAndPath> deletedTestExecutionPartitionAndPaths) throws StorageException {
        LOGGER.trace(TestHistorySynchronizer.TS33927_LOG_MARKER, () -> "Removing test executions from test link index for: " + String.valueOf(deletedTestExecutionPartitionAndPaths));
        Map<String, List<PartitionAndPath>> deletedTestExecutionsByUniformPath = deletedTestExecutionPartitionAndPaths.stream().collect(Collectors.groupingBy(PartitionAndPath::getUniformPath));
        ArrayList<String> deletedTestExecutionUniformPaths = new ArrayList<String>(deletedTestExecutionsByUniformPath.keySet());
        List testLinksList = this.delegate.getValues(deletedTestExecutionUniformPaths);
        PairList pathsWithUpdatedLinks = new PairList();
        ArrayList<String> pathsToRemove = new ArrayList<String>();
        PairList removedPathAndImplementation = new PairList();
        for (int i = 0; i < testLinksList.size(); ++i) {
            String testExecutionPath = deletedTestExecutionUniformPaths.get(i);
            TestLinks testLinks = (TestLinks)testLinksList.get(i);
            if (testLinks == null) {
                LOGGER.debug("No test links found for test execution with uniform path '{}'! Missing links are expected in merge commits in cases where the TestExecutionMerger adds test executions that are deleted by the AnalysisReportPersister in the same commit.", (Object)testExecutionPath);
                continue;
            }
            testLinks.removePartitions(CollectionUtils.map((Collection)deletedTestExecutionsByUniformPath.get(testExecutionPath), PartitionAndPath::getPartition));
            if (testLinks.getPartitions().isEmpty()) {
                pathsToRemove.add(testExecutionPath);
                if (testLinks.getTestImplementation() == null) continue;
                pathsWithUpdatedLinks.add((Object)testLinks.getTestImplementation(), (Object)testLinks);
                removedPathAndImplementation.add((Object)testExecutionPath, (Object)testLinks.getTestImplementation());
                continue;
            }
            pathsWithUpdatedLinks.add((Object)testExecutionPath, (Object)testLinks);
        }
        this.delegate.setValues(pathsWithUpdatedLinks);
        this.delegate.removeValues(pathsToRemove);
        return removedPathAndImplementation;
    }

    public List<TestLinks> getTestLinks(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public List<TestLinks> getTestLinks(List<String> uniformPaths, boolean forceExistence) throws StorageException {
        return this.delegate.getValues(uniformPaths, forceExistence);
    }

    public List<String> getAllUniformPaths() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public TestLinks getTestLinks(String uniformPath) throws StorageException {
        return (TestLinks)this.delegate.getValue(uniformPath);
    }

    public PairList<String, TestLinks> getAllTestLinks() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

