/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.tests.TestExecutionDeltaIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import java.util.ArrayList;
import java.util.Collection;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestExecutionDeltaIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=TestExecutionIndex.class)
    private TestExecutionIndexDelta testExecutionDelta;
    @DeltaSource(value=ExecutionUnitIndex.class)
    private TestExecutionIndexDelta executionUnitDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestExecutionDeltaIndex testExecutionDeltaIndex;

    public void execute() throws StorageException {
        ArrayList partitionAndPaths = CollectionUtils.unionList(this.testExecutionDelta.getAddedOrChangedPartitionsAndPaths(), (Collection[])new Collection[]{this.executionUnitDelta.getAddedOrChangedPartitionsAndPaths()});
        this.testExecutionDeltaIndex.insertOrMerge(this.getSchedulingCommit(), partitionAndPaths);
    }
}

