/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.tests.TestExecutionWithPartition;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class TestHistoryEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="executionUnitUniformPath")
    private @Nullable String executionUnitUniformPath;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="codeLocation")
    private final @Nullable String codeLocation;
    @JsonProperty(value="results")
    private final Map<String, ETestExecutionResult> results;
    @JsonProperty(value="durations")
    private final Map<String, Long> durations;

    public TestHistoryEntry(String uniformPath, String name, @Nullable String codeLocation, @NonNull Collection<TestExecutionWithPartition> executions) {
        this(uniformPath, name, codeLocation);
        for (TestExecutionWithPartition execution : executions) {
            this.durations.put(execution.getPartition(), (long)execution.getTestExecution().getDurationMillis());
            this.results.put(execution.getPartition(), execution.getTestExecution().getResult());
        }
        if (!executions.isEmpty()) {
            TestExecution testExecution = Objects.requireNonNull((TestExecutionWithPartition)CollectionUtils.getAny(executions)).getTestExecution();
            this.executionUnitUniformPath = testExecution.getExecutionUnit();
        }
    }

    private TestHistoryEntry(String uniformPath, String name, @Nullable String codeLocation, Map<String, Long> durations, Map<String, ETestExecutionResult> results, @Nullable String executionUnitUniformPath) {
        this(uniformPath, name, codeLocation);
        this.executionUnitUniformPath = executionUnitUniformPath;
        this.durations.putAll(durations);
        this.results.putAll(results);
    }

    private TestHistoryEntry(String uniformPath, String name, @Nullable String codeLocation) {
        this.uniformPath = uniformPath;
        this.name = name;
        this.codeLocation = codeLocation;
        this.durations = new HashMap<String, Long>();
        this.results = new HashMap<String, ETestExecutionResult>();
        this.executionUnitUniformPath = null;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public @Nullable String getExecutionUnitUniformPath() {
        return this.executionUnitUniformPath;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getCodeLocation() {
        return this.codeLocation;
    }

    public Set<String> getPartitions() {
        return this.results.keySet();
    }

    public Map<String, ETestExecutionResult> getResults() {
        return this.results;
    }

    public Map<String, Long> getDurations() {
        return this.durations;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public TestHistoryEntry copyWithDataForPartitionOnly(@Nullable String partition) {
        Map partitionDurations = Maps.filterKeys(this.durations, key -> key.equals(partition));
        Map partitionResults = Maps.filterKeys(this.results, key -> key.equals(partition));
        return new TestHistoryEntry(this.uniformPath, this.name, this.codeLocation, partitionDurations, partitionResults, this.executionUnitUniformPath);
    }

    public PairList<String, TestHistoryEntry> expandToOnePerPartition() {
        HashSet<String> allPartitions = new HashSet<String>();
        allPartitions.addAll(this.durations.keySet());
        allPartitions.addAll(this.results.keySet());
        if (allPartitions.isEmpty()) {
            return PairList.from((Object)"", (Object)this.copyWithDataForPartitionOnly(null));
        }
        PairList result = new PairList();
        allPartitions.forEach(partition -> result.add(partition, (Object)this.copyWithDataForPartitionOnly((String)partition)));
        return result;
    }
}

