/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.TrackedUnit;
import com.teamscale.index.tracking.algorithm.TrackedUnitUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TrackedElement {
    private final List<TrackedUnit> units;
    private final String uniformPath;

    public TrackedElement(String uniformPath, List<TrackedUnit> units) {
        this.uniformPath = uniformPath;
        this.units = new ArrayList<TrackedUnit>(units);
    }

    public List<TrackedUnit> getUnits() {
        return this.units;
    }

    public int getUnitIndexForOffset(int offset) {
        int result = Collections.binarySearch(this.units, new TrackedUnit("", offset, offset), Comparator.comparingInt(TrackedUnit::getStartOffset));
        if (result >= 0) {
            return result;
        }
        if ((result = -result - 1) > 0 && offset <= this.units.get(result - 1).getEndOffset()) {
            return result - 1;
        }
        return result;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.uniformPath);
        TrackedUnitUtils.appendUnits(this.units, builder, true);
        return builder.toString();
    }
}

