/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class TrackedUnit {
    private final int startOffset;
    private final int endOffset;
    private final String content;
    private final @Nullable List<String> contentFragments;

    public TrackedUnit(List<IToken> tokens) {
        CCSMAssert.isFalse((boolean)tokens.isEmpty(), (String)"Must provide non-empty token list.");
        this.startOffset = tokens.get(0).getOffset();
        this.endOffset = ((IToken)CollectionUtils.getLast(tokens)).getEndOffset();
        if (tokens.size() > 1) {
            this.contentFragments = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            for (IToken token : tokens) {
                builder.append(token.getText());
                this.contentFragments.add(token.getText());
            }
            this.content = builder.toString();
        } else {
            this.contentFragments = null;
            this.content = tokens.get(0).getText();
        }
    }

    TrackedUnit(String commentText, int startOffset, int endOffset) {
        this.content = commentText;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.contentFragments = null;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getContent() {
        return this.content;
    }

    @Nullable List<String> getContentFragments() {
        return this.contentFragments;
    }

    public boolean equals(Object other) {
        return other instanceof TrackedUnit && this.content.equals(((TrackedUnit)other).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        return this.startOffset + "-" + this.endOffset + ": " + this.content;
    }
}

