/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import ua_parser.Parser;

public final class UserAgentParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ADDITIONAL_RULES_FILE = "/ua_parser/custom_regexes.yaml";
    private static final Set<String> ALREADY_ENCOUNTERED_ERRORS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ua_parser.UserAgentParser DELEGATE = ua_parser.UserAgentParser.fromList(UserAgentParser.loadParserConfig());

    private static List<Map<String, String>> loadParserConfig() {
        List<Resource> inputs = List.of(Resource.of(Parser.class, (String)"/ua_parser/regexes.yaml"), Resource.of(UserAgentParser.class, (String)ADDITIONAL_RULES_FILE));
        ArrayList<Map<String, String>> parserConfigs = new ArrayList<Map<String, String>>();
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(Parser.getDefaultLoaderOptions()));
        for (Resource resource : inputs) {
            try {
                InputStream stream = resource.getAsStream();
                try {
                    Map regexConfig = (Map)yaml.load(stream);
                    List userAgentParsers = regexConfig.getOrDefault("user_agent_parsers", Collections.emptyList());
                    if (userAgentParsers.isEmpty()) {
                        throw new IllegalArgumentException("No 'user_agent_parsers' found in: %s".formatted(resource));
                    }
                    parserConfigs.addAll(userAgentParsers);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unexpected IOException while loading: %s".formatted(resource), e);
            }
        }
        return parserConfigs;
    }

    public static UserAgent parse(String userAgentString) {
        ua_parser.UserAgent userAgent = DELEGATE.parse(userAgentString);
        return UserAgentParser.postProcess(userAgentString, userAgent);
    }

    private static UserAgent postProcess(String userAgentString, ua_parser.UserAgent userAgent) {
        String family = UserAgentParser.parseFamily(userAgentString, userAgent.family);
        int major = UserAgentParser.parseVersion(userAgentString, userAgent.major);
        return new UserAgent(family, major);
    }

    private static String parseFamily(String userAgentString, String familyString) {
        if (StringUtils.isEmpty((String)familyString)) {
            if (ALREADY_ENCOUNTERED_ERRORS.add(userAgentString + "FAMILY")) {
                LOGGER.warn("Invalid user agent family '{}' returned from user agent parser for user agent string: {}", (Object)familyString, (Object)userAgentString);
            }
            return "unknown";
        }
        return familyString;
    }

    private static int parseVersion(String userAgentString, String versionPart) {
        try {
            return Integer.parseInt(versionPart);
        }
        catch (NumberFormatException e) {
            if (ALREADY_ENCOUNTERED_ERRORS.add(userAgentString + "VERSION")) {
                LOGGER.warn("Invalid version number '{}' returned from user agent parser for user agent string: {}", (Object)versionPart, (Object)userAgentString);
            }
            return 0;
        }
    }

    public record UserAgent(String family, int major) {
    }
}

