/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.user.User;
import com.teamscale.core.utils.TimestampedInteraction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.LastChangeTrackingValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;

final class UserRecentInteractionIndex<T extends Comparable<? super T>>
implements IUtilityIndex {
    private static final int DEFAULT_MAX_STORED_ITEMS_PER_USER = 15;
    private final int maxStoredItemsPerUser;
    private final LastChangeTrackingValueIndex<LinkedList<TimestampedInteraction<T>>> delegate;

    public UserRecentInteractionIndex(IStore store, Integer numItems) {
        this.delegate = new LastChangeTrackingValueIndex(store);
        this.maxStoredItemsPerUser = numItems;
    }

    public UserRecentInteractionIndex(IStore store) {
        this(store, 15);
    }

    public void registerItemInteraction(String userName, TimestampedInteraction<T> itemTimestampedInteraction) throws StorageException {
        this.delegate.runLocked("update", () -> this.doRegisterItemInteraction(userName, itemTimestampedInteraction));
    }

    private void doRegisterItemInteraction(String userName, TimestampedInteraction<T> itemTimestampedInteraction) throws StorageException {
        LinkedList<TimestampedInteraction<T>> recentItems = this.getRecentItemsUnlocked(userName);
        int indexToInsert = UserRecentInteractionIndex.getIndexToInsert(itemTimestampedInteraction, recentItems);
        if (indexToInsert == -1) {
            return;
        }
        recentItems.add(indexToInsert, itemTimestampedInteraction);
        recentItems.removeIf(item -> item.identifier().equals(itemTimestampedInteraction.identifier()) && itemTimestampedInteraction != item);
        while (recentItems.size() > this.maxStoredItemsPerUser) {
            recentItems.removeLast();
        }
        this.delegate.setValue(userName, recentItems);
    }

    public void registerItemInteraction(String userName, T item) throws StorageException {
        this.registerItemInteraction(userName, (T)new TimestampedInteraction(Long.valueOf(System.currentTimeMillis()), item));
    }

    private static <T extends Comparable<? super T>> int getIndexToInsert(TimestampedInteraction<T> itemTimestampedInteraction, LinkedList<TimestampedInteraction<T>> recentItems) {
        long itemToInsertTimestamp = itemTimestampedInteraction.timestamp();
        Comparable itemToInsertIdentifier = itemTimestampedInteraction.identifier();
        for (int i = 0; i < recentItems.size(); ++i) {
            TimestampedInteraction<T> currentItem = recentItems.get(i);
            if (itemToInsertIdentifier.equals(currentItem.identifier()) && currentItem.timestamp() > itemToInsertTimestamp) {
                return -1;
            }
            if (itemToInsertTimestamp < currentItem.timestamp()) continue;
            return i;
        }
        return recentItems.size();
    }

    public void removeItemInteraction(String userName, String identifier) throws StorageException {
        this.delegate.runLocked(userName, () -> {
            LinkedList<TimestampedInteraction<T>> recentItems = this.getRecentItemsUnlocked(userName);
            recentItems.removeIf(timestampedInteraction -> identifier.equals(timestampedInteraction.identifier()));
            this.delegate.setValue(userName, recentItems);
        });
    }

    private List<TimestampedInteraction<T>> getRecentItemsWithTimestamps(String userName) throws StorageException {
        return (List)this.delegate.computeLocked(userName, () -> this.getRecentItemsUnlocked(userName));
    }

    public List<T> getRecentItems(String userName) throws StorageException {
        return this.getRecentItemsWithTimestamps(userName).stream().map(TimestampedInteraction::identifier).toList();
    }

    private @NonNull LinkedList<TimestampedInteraction<T>> getRecentItemsUnlocked(String userName) throws StorageException {
        return Optional.ofNullable((LinkedList)this.delegate.getValue(userName)).orElse(new LinkedList());
    }

    public List<TimestampedInteraction<T>> getRecentRelatedItems(User user) throws StorageException {
        ArrayList<TimestampedInteraction<T>> result = new ArrayList<TimestampedInteraction<T>>();
        result.addAll(this.getRecentItemsWithTimestamps(user.getUsername()));
        result.addAll(this.getRecentItemsWithTimestamps(user.getFullName()));
        for (String alias : user.getAliases()) {
            result.addAll(this.getRecentItemsWithTimestamps(alias));
        }
        return this.removeDuplicatedIdentifierEntries(result.stream().sorted(Collections.reverseOrder(TimestampedInteraction.timestampedInteractionComparator())));
    }

    private List<TimestampedInteraction<T>> removeDuplicatedIdentifierEntries(Stream<TimestampedInteraction<T>> interactions) {
        ArrayList duplicateFreeResult = new ArrayList();
        interactions.forEach(interaction -> {
            if (duplicateFreeResult.stream().noneMatch(entry -> entry.identifier().equals(interaction.identifier()))) {
                duplicateFreeResult.add((TimestampedInteraction)interaction);
            }
        });
        return duplicateFreeResult;
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }

    public IStore getWrappedStore() {
        return this.delegate.getWrappedStore();
    }
}

