/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.index.CommitAssociationIndexBase;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.index.user.UserRecentlyCommittedCommitsIndex;
import com.teamscale.index.user.UserRecentlyInteractedBranchesIndex;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;

public class UserRecentlyCommittedBranchesSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogIndex repositoryLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private UserRecentlyCommittedCommitsIndex userRecentlyCommittedCommitsIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private UserIndex userIndex;
    @DeltaSource(value=RepositoryLogIndex.class)
    private KeyDelta delta;

    public void execute() throws Exception {
        List commits = CommitAssociationIndexBase.deltaToCommits((KeyDelta)this.delta);
        if (commits.isEmpty()) {
            return;
        }
        UserAliasLookup lookup = UserAliasLookup.createInstance(this.userIndex);
        for (CommitDescriptor commit : commits) {
            String author;
            RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(commit);
            if (entry == null || "Teamscale import".equals(author = entry.getAuthor())) continue;
            Optional<User> user = lookup.resolveAuthorOf(entry);
            String username = author;
            if (user.isPresent()) {
                username = user.get().getUsername();
            }
            this.userRecentlyInteractedBranchesIndex.registerInteractedBranch(username, commit.getBranchName(), entry.getTimestamp());
            this.userRecentlyCommittedCommitsIndex.registerCommit(username, commit);
        }
    }
}

