/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import kotlin.coroutines.AbstractCoroutineContextElement;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ThreadContextElement;
import kotlinx.coroutines.reactor.ReactorContext;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ClassUtils;
import reactor.util.context.Context;

public final class PropagationContextElement
extends AbstractCoroutineContextElement
implements ThreadContextElement<ContextSnapshot.Scope> {
    public static final Key Key = new Key();
    private static final ContextSnapshotFactory contextSnapshotFactory = ContextSnapshotFactory.builder().contextRegistry(ContextRegistry.getInstance()).build();
    private static final boolean coroutinesReactorPresent = ClassUtils.isPresent("kotlinx.coroutines.reactor.ReactorContext", PropagationContextElement.class.getClassLoader());
    private final ContextSnapshot threadLocalContextSnapshot = contextSnapshotFactory.captureAll(new Object[0]);

    public PropagationContextElement() {
        super((CoroutineContext.Key)Key);
    }

    public void restoreThreadContext(CoroutineContext context, ContextSnapshot.Scope oldState) {
        oldState.close();
    }

    public ContextSnapshot.Scope updateThreadContext(CoroutineContext context) {
        ContextSnapshot contextSnapshot;
        if (coroutinesReactorPresent) {
            contextSnapshot = ReactorDelegate.captureFrom(context);
            if (contextSnapshot == null) {
                contextSnapshot = this.threadLocalContextSnapshot;
            }
        } else {
            contextSnapshot = this.threadLocalContextSnapshot;
        }
        return contextSnapshot.setThreadLocals();
    }

    public static final class Key
    implements CoroutineContext.Key<PropagationContextElement> {
    }

    private static final class ReactorDelegate {
        private ReactorDelegate() {
        }

        public static @Nullable ContextSnapshot captureFrom(CoroutineContext context) {
            Context contextView;
            ReactorContext reactorContext = (ReactorContext)context.get((CoroutineContext.Key)ReactorContext.Key);
            Context context2 = contextView = reactorContext != null ? reactorContext.getContext() : null;
            if (contextView != null) {
                return contextSnapshotFactory.captureFrom(new Object[]{contextView});
            }
            return null;
        }
    }
}

