/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.DBOptions;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;

public class EnvOptions
extends RocksObject {
    private RateLimiter rateLimiter;

    public EnvOptions() {
        super(EnvOptions.newEnvOptions());
    }

    public EnvOptions(DBOptions dbOptions) {
        super(EnvOptions.newEnvOptions(dbOptions.nativeHandle_));
    }

    public EnvOptions setUseMmapReads(boolean useMmapReads) {
        this.setUseMmapReads(this.nativeHandle_, useMmapReads);
        return this;
    }

    public boolean useMmapReads() {
        assert (this.isOwningHandle());
        return this.useMmapReads(this.nativeHandle_);
    }

    public EnvOptions setUseMmapWrites(boolean useMmapWrites) {
        this.setUseMmapWrites(this.nativeHandle_, useMmapWrites);
        return this;
    }

    public boolean useMmapWrites() {
        assert (this.isOwningHandle());
        return this.useMmapWrites(this.nativeHandle_);
    }

    public EnvOptions setUseDirectReads(boolean useDirectReads) {
        this.setUseDirectReads(this.nativeHandle_, useDirectReads);
        return this;
    }

    public boolean useDirectReads() {
        assert (this.isOwningHandle());
        return this.useDirectReads(this.nativeHandle_);
    }

    public EnvOptions setUseDirectWrites(boolean useDirectWrites) {
        this.setUseDirectWrites(this.nativeHandle_, useDirectWrites);
        return this;
    }

    public boolean useDirectWrites() {
        assert (this.isOwningHandle());
        return this.useDirectWrites(this.nativeHandle_);
    }

    public EnvOptions setAllowFallocate(boolean allowFallocate) {
        this.setAllowFallocate(this.nativeHandle_, allowFallocate);
        return this;
    }

    public boolean allowFallocate() {
        assert (this.isOwningHandle());
        return this.allowFallocate(this.nativeHandle_);
    }

    public EnvOptions setSetFdCloexec(boolean setFdCloexec) {
        this.setSetFdCloexec(this.nativeHandle_, setFdCloexec);
        return this;
    }

    public boolean setFdCloexec() {
        assert (this.isOwningHandle());
        return this.setFdCloexec(this.nativeHandle_);
    }

    public EnvOptions setBytesPerSync(long bytesPerSync) {
        this.setBytesPerSync(this.nativeHandle_, bytesPerSync);
        return this;
    }

    public long bytesPerSync() {
        assert (this.isOwningHandle());
        return this.bytesPerSync(this.nativeHandle_);
    }

    public EnvOptions setFallocateWithKeepSize(boolean fallocateWithKeepSize) {
        this.setFallocateWithKeepSize(this.nativeHandle_, fallocateWithKeepSize);
        return this;
    }

    public boolean fallocateWithKeepSize() {
        assert (this.isOwningHandle());
        return this.fallocateWithKeepSize(this.nativeHandle_);
    }

    public EnvOptions setCompactionReadaheadSize(long compactionReadaheadSize) {
        this.setCompactionReadaheadSize(this.nativeHandle_, compactionReadaheadSize);
        return this;
    }

    public long compactionReadaheadSize() {
        assert (this.isOwningHandle());
        return this.compactionReadaheadSize(this.nativeHandle_);
    }

    public EnvOptions setRandomAccessMaxBufferSize(long randomAccessMaxBufferSize) {
        this.setRandomAccessMaxBufferSize(this.nativeHandle_, randomAccessMaxBufferSize);
        return this;
    }

    public long randomAccessMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.randomAccessMaxBufferSize(this.nativeHandle_);
    }

    public EnvOptions setWritableFileMaxBufferSize(long writableFileMaxBufferSize) {
        this.setWritableFileMaxBufferSize(this.nativeHandle_, writableFileMaxBufferSize);
        return this;
    }

    public long writableFileMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.writableFileMaxBufferSize(this.nativeHandle_);
    }

    public EnvOptions setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        this.setRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        return this;
    }

    public RateLimiter rateLimiter() {
        assert (this.isOwningHandle());
        return this.rateLimiter;
    }

    private static native long newEnvOptions();

    private static native long newEnvOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setUseMmapReads(long var1, boolean var3);

    private native boolean useMmapReads(long var1);

    private native void setUseMmapWrites(long var1, boolean var3);

    private native boolean useMmapWrites(long var1);

    private native void setUseDirectReads(long var1, boolean var3);

    private native boolean useDirectReads(long var1);

    private native void setUseDirectWrites(long var1, boolean var3);

    private native boolean useDirectWrites(long var1);

    private native void setAllowFallocate(long var1, boolean var3);

    private native boolean allowFallocate(long var1);

    private native void setSetFdCloexec(long var1, boolean var3);

    private native boolean setFdCloexec(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    private native void setFallocateWithKeepSize(long var1, boolean var3);

    private native boolean fallocateWithKeepSize(long var1);

    private native void setCompactionReadaheadSize(long var1, long var3);

    private native long compactionReadaheadSize(long var1);

    private native void setRandomAccessMaxBufferSize(long var1, long var3);

    private native long randomAccessMaxBufferSize(long var1);

    private native void setWritableFileMaxBufferSize(long var1, long var3);

    private native long writableFileMaxBufferSize(long var1);

    private native void setRateLimiter(long var1, long var3);

    static {
        RocksDB.loadLibrary();
    }
}

