/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.Status;

public class FileOperationInfo {
    private final String path;
    private final long offset;
    private final long length;
    private final long startTimestamp;
    private final long duration;
    private final Status status;

    FileOperationInfo(String path, long offset, long length, long startTimestamp, long duration, Status status) {
        this.path = path;
        this.offset = offset;
        this.length = length;
        this.startTimestamp = startTimestamp;
        this.duration = duration;
        this.status = status;
    }

    public String getPath() {
        return this.path;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileOperationInfo that = (FileOperationInfo)o;
        return this.offset == that.offset && this.length == that.length && this.startTimestamp == that.startTimestamp && this.duration == that.duration && Objects.equals(this.path, that.path) && Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.offset, this.length, this.startTimestamp, this.duration, this.status);
    }

    public String toString() {
        return "FileOperationInfo{path='" + this.path + '\'' + ", offset=" + this.offset + ", length=" + this.length + ", startTimestamp=" + this.startTimestamp + ", duration=" + this.duration + ", status=" + this.status + '}';
    }
}

