/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksCallbackObject;

public abstract class Logger
extends RocksCallbackObject {
    private static final long WITH_OPTIONS = 0L;
    private static final long WITH_DBOPTIONS = 1L;

    public Logger(Options options) {
        super(options.nativeHandle_, 0L);
    }

    public Logger(DBOptions dboptions) {
        super(dboptions.nativeHandle_, 1L);
    }

    @Override
    protected long initializeNative(long ... nativeParameterHandles) {
        if (nativeParameterHandles[1] == 0L) {
            return this.createNewLoggerOptions(nativeParameterHandles[0]);
        }
        if (nativeParameterHandles[1] == 1L) {
            return this.createNewLoggerDbOptions(nativeParameterHandles[0]);
        }
        throw new IllegalArgumentException();
    }

    public void setInfoLogLevel(InfoLogLevel infoLogLevel) {
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
    }

    public InfoLogLevel infoLogLevel() {
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    protected abstract void log(InfoLogLevel var1, String var2);

    protected native long createNewLoggerOptions(long var1);

    protected native long createNewLoggerDbOptions(long var1);

    protected native void setInfoLogLevel(long var1, byte var3);

    protected native byte infoLogLevel(long var1);

    @Override
    protected void disposeInternal() {
        this.disposeInternal(this.nativeHandle_);
    }

    private native void disposeInternal(long var1);
}

