/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.RateLimiterMode;
import org.rocksdb.RocksObject;

public class RateLimiter
extends RocksObject {
    public static final long DEFAULT_REFILL_PERIOD_MICROS = 100000L;
    public static final int DEFAULT_FAIRNESS = 10;
    public static final RateLimiterMode DEFAULT_MODE = RateLimiterMode.WRITES_ONLY;
    public static final boolean DEFAULT_AUTOTUNE = false;

    public RateLimiter(long rateBytesPerSecond) {
        this(rateBytesPerSecond, 100000L, 10, DEFAULT_MODE, false);
    }

    public RateLimiter(long rateBytesPerSecond, long refillPeriodMicros) {
        this(rateBytesPerSecond, refillPeriodMicros, 10, DEFAULT_MODE, false);
    }

    public RateLimiter(long rateBytesPerSecond, long refillPeriodMicros, int fairness) {
        this(rateBytesPerSecond, refillPeriodMicros, fairness, DEFAULT_MODE, false);
    }

    public RateLimiter(long rateBytesPerSecond, long refillPeriodMicros, int fairness, RateLimiterMode rateLimiterMode) {
        this(rateBytesPerSecond, refillPeriodMicros, fairness, rateLimiterMode, false);
    }

    public RateLimiter(long rateBytesPerSecond, long refillPeriodMicros, int fairness, RateLimiterMode rateLimiterMode, boolean autoTune) {
        super(RateLimiter.newRateLimiterHandle(rateBytesPerSecond, refillPeriodMicros, fairness, rateLimiterMode.getValue(), autoTune));
    }

    public void setBytesPerSecond(long bytesPerSecond) {
        assert (this.isOwningHandle());
        this.setBytesPerSecond(this.nativeHandle_, bytesPerSecond);
    }

    public long getBytesPerSecond() {
        assert (this.isOwningHandle());
        return this.getBytesPerSecond(this.nativeHandle_);
    }

    public void request(long bytes) {
        assert (this.isOwningHandle());
        this.request(this.nativeHandle_, bytes);
    }

    public long getSingleBurstBytes() {
        assert (this.isOwningHandle());
        return this.getSingleBurstBytes(this.nativeHandle_);
    }

    public long getTotalBytesThrough() {
        assert (this.isOwningHandle());
        return this.getTotalBytesThrough(this.nativeHandle_);
    }

    public long getTotalRequests() {
        assert (this.isOwningHandle());
        return this.getTotalRequests(this.nativeHandle_);
    }

    private static native long newRateLimiterHandle(long var0, long var2, int var4, byte var5, boolean var6);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setBytesPerSecond(long var1, long var3);

    private native long getBytesPerSecond(long var1);

    private native void request(long var1, long var3);

    private native long getSingleBurstBytes(long var1);

    private native long getTotalBytesThrough(long var1);

    private native long getTotalRequests(long var1);
}

