/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.AbstractSlice;

public class Slice
extends AbstractSlice<byte[]> {
    private volatile boolean cleared;
    private volatile long internalBufferOffset = 0L;

    private Slice() {
    }

    Slice(long nativeHandle) {
        this(nativeHandle, false);
    }

    Slice(long nativeHandle, boolean owningNativeHandle) {
        this.setNativeHandle(nativeHandle, owningNativeHandle);
    }

    public Slice(String str) {
        super(Slice.createNewSliceFromString(str));
    }

    public Slice(byte[] data, int offset) {
        super(Slice.createNewSlice0(data, offset));
    }

    public Slice(byte[] data) {
        super(Slice.createNewSlice1(data));
    }

    @Override
    public void clear() {
        this.clear0(this.getNativeHandle(), !this.cleared, this.internalBufferOffset);
        this.cleared = true;
    }

    @Override
    public void removePrefix(int n) {
        this.removePrefix0(this.getNativeHandle(), n);
        this.internalBufferOffset += (long)n;
    }

    @Override
    protected void disposeInternal() {
        long nativeHandle = this.getNativeHandle();
        if (!this.cleared) {
            this.disposeInternalBuf(nativeHandle, this.internalBufferOffset);
        }
        super.disposeInternal(nativeHandle);
    }

    @Override
    protected final native byte[] data0(long var1);

    private static native long createNewSlice0(byte[] var0, int var1);

    private static native long createNewSlice1(byte[] var0);

    private native void clear0(long var1, boolean var3, long var4);

    private native void removePrefix0(long var1, int var3);

    private native void disposeInternalBuf(long var1, long var3);
}

