/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.TableFileCreationReason;

public class TableFileCreationBriefInfo {
    private final String dbName;
    private final String columnFamilyName;
    private final String filePath;
    private final int jobId;
    private final TableFileCreationReason reason;

    protected TableFileCreationBriefInfo(String dbName, String columnFamilyName, String filePath, int jobId, byte tableFileCreationReasonValue) {
        this.dbName = dbName;
        this.columnFamilyName = columnFamilyName;
        this.filePath = filePath;
        this.jobId = jobId;
        this.reason = TableFileCreationReason.fromValue(tableFileCreationReasonValue);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getJobId() {
        return this.jobId;
    }

    public TableFileCreationReason getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFileCreationBriefInfo that = (TableFileCreationBriefInfo)o;
        return this.jobId == that.jobId && Objects.equals(this.dbName, that.dbName) && Objects.equals(this.columnFamilyName, that.columnFamilyName) && Objects.equals(this.filePath, that.filePath) && this.reason == that.reason;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dbName, this.columnFamilyName, this.filePath, this.jobId, this.reason});
    }

    public String toString() {
        return "TableFileCreationBriefInfo{dbName='" + this.dbName + '\'' + ", columnFamilyName='" + this.columnFamilyName + '\'' + ", filePath='" + this.filePath + '\'' + ", jobId=" + this.jobId + ", reason=" + (Object)((Object)this.reason) + '}';
    }
}

