/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.Status;
import org.rocksdb.TableFileCreationBriefInfo;
import org.rocksdb.TableProperties;

public class TableFileCreationInfo
extends TableFileCreationBriefInfo {
    private final long fileSize;
    private final TableProperties tableProperties;
    private final Status status;

    protected TableFileCreationInfo(long fileSize, TableProperties tableProperties, Status status, String dbName, String columnFamilyName, String filePath, int jobId, byte tableFileCreationReasonValue) {
        super(dbName, columnFamilyName, filePath, jobId, tableFileCreationReasonValue);
        this.fileSize = fileSize;
        this.tableProperties = tableProperties;
        this.status = status;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public TableProperties getTableProperties() {
        return this.tableProperties;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFileCreationInfo that = (TableFileCreationInfo)o;
        return this.fileSize == that.fileSize && Objects.equals(this.tableProperties, that.tableProperties) && Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fileSize, this.tableProperties, this.status);
    }

    @Override
    public String toString() {
        return "TableFileCreationInfo{fileSize=" + this.fileSize + ", tableProperties=" + this.tableProperties + ", status=" + this.status + '}';
    }
}

