/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.SystemVariablesCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-control-flow-depending-on-system-variable", languages={ELanguage.ABAP}, parameters={})
public class ControlFlowDependingOnSystemVariableCheck
extends SystemVariablesCheckBase {
    static final String CHECK_NAME = "Control flow depending on system variables";
    @CheckOption(name="Control flow depending on system variables - relevant system variables", description="Fields of SY structure to be considered. If empty, all fields are considered.")
    private Set<String> systemFieldsToCheck = CollectionUtils.asHashSet((Object[])new String[]{"UNAME", "MANDT", "SYSID", "HOST", "OPSYS", "DBSYS"});
    @CheckOption(name="Control flow depending on system variables - relevant context info methods", description="Static methods of the `CL_ABAP_CONTEXT_INFO` class to be considered. If empty, all methods are considered.")
    private Set<String> abapContextInfoMethodsToCheck = CollectionUtils.asHashSet((Object[])new String[]{"GET_USER_TECHNICAL_NAME", "GET_USER_FORMATTED_NAME", "GET_USER_DESCRIPTION", "GET_USER_BUSINESS_PARTNER_ID", "GET_USER_ALIAS"});
    @CheckOption(name="Control flow depending on system variables - relevant system methods", description="Static methods of the `CL_ABAP_SYST` class to be considered. If empty, all methods are considered.")
    private Set<String> abapSystemMethodsToCheck = CollectionUtils.asHashSet((Object[])new String[]{"GET_ALIAS_USER", "GET_CLIENT", "GET_HOST_NAME", "GET_INSTANCE_NAME", "GET_USER_NAME"});

    @Override
    protected Set<String> getSystemFieldsToCheck() {
        return this.systemFieldsToCheck;
    }

    @Override
    protected Set<String> getAbapContextInfoMethodsToCheck() {
        return this.abapContextInfoMethodsToCheck;
    }

    @Override
    protected Set<String> getAbapSystemMethodsToCheck() {
        return this.abapSystemMethodsToCheck;
    }

    @Override
    protected void performSystemVariableCheck(List<IToken> tokens, int index) throws CheckException {
        if (ControlFlowDependingOnSystemVariableCheck.isInControlStatement(tokens, index)) {
            IToken token = tokens.get(index);
            this.buildFinding("Control flow depends on system variable `" + token.getText().toUpperCase() + "`", this.buildLocation().forToken(token)).createAndStore();
        }
    }

    @Override
    protected void performAbapSystemVariableMethodCheck(List<IToken> tokens, int index) throws CheckException {
        if (ControlFlowDependingOnSystemVariableCheck.isInControlStatement(tokens, index)) {
            IToken classToken = tokens.get(index);
            IToken methodToken = tokens.get(index + 2);
            this.buildFinding("Control flow depends on method call " + MarkupUtils.formatAsSourceCode((String)(classToken.getText().toUpperCase() + "=>" + methodToken.getText().toUpperCase())), this.buildLocation().forToken(classToken)).createAndStore();
        }
    }

    @Override
    protected void performAbapXcoLibraryMethodCheck(List<IToken> tokens, int index) throws CheckException {
        if (ControlFlowDependingOnSystemVariableCheck.isInControlStatement(tokens, index)) {
            IToken classToken = tokens.get(index);
            IToken methodToken = tokens.get(index + 4);
            this.buildFinding("Control flow depends on method call " + MarkupUtils.formatAsSourceCode((String)(classToken.getText().toUpperCase() + "=>SY->" + methodToken.getText().toUpperCase())), this.buildLocation().forToken(classToken)).createAndStore();
        }
    }
}

