/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CriticalStatementsCheckBase
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final Map<String, List<ETokenType[]>> subTypeToTokensMap = new HashMap<String, List<ETokenType[]>>();

    public void execute() throws CheckException {
        Set<String> targetSubtypes = this.parseStatementsOption();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!targetSubtypes.contains(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private Set<String> parseStatementsOption() {
        HashSet<String> subtypes = new HashSet<String>();
        Iterator<String> iterator = this.getStatements().iterator();
        while (iterator.hasNext()) {
            String[] keywords = WHITESPACE_PATTERN.split(iterator.next().trim());
            if (StringUtils.isEmpty((String)keywords[0])) continue;
            String subType = LanguageFeatureParser.ABAP.normalizeVariable(keywords[0]);
            if (subType.equals("exec")) {
                subType = "native SQL";
            }
            subtypes.add(subType);
            if (keywords.length <= 1) continue;
            this.addToSubTypesToTokensMap(subType, keywords);
        }
        return subtypes;
    }

    private void addToSubTypesToTokensMap(String subType, String[] keywords) {
        ETokenType[] tokenTypes = new ETokenType[keywords.length];
        for (int i = 0; i < keywords.length; ++i) {
            String userInputType = keywords[i].toUpperCase().replace('-', '_');
            Optional tokenType = Enums.getIfPresent(ETokenType.class, (String)userInputType);
            if (!tokenType.isPresent()) {
                LOGGER.error(this.getTokenTypeNotFoundErrorMessage(userInputType, keywords));
                return;
            }
            tokenTypes[i] = (ETokenType)tokenType.get();
        }
        List tokenTypesForEntitySubtype = this.subTypeToTokensMap.computeIfAbsent(subType, key -> new ArrayList());
        tokenTypesForEntitySubtype.add(tokenTypes);
    }

    private String getTokenTypeNotFoundErrorMessage(String userInputType, String[] keywords) {
        String statement = String.join((CharSequence)" ", keywords);
        return "Keyword '" + userInputType + "' is not known. Skipping statement '" + statement + "'!";
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        String subType = entity.getSubtype();
        String statement = "";
        if (this.subTypeToTokensMap.containsKey(subType)) {
            List<ETokenType[]> possibleStartTokens = this.subTypeToTokensMap.get(subType);
            boolean entityMatchesCriticalStatement = false;
            for (Object[] objectArray : possibleStartTokens) {
                if (!TokenStreamUtils.startsWith((List)entity.ownStartTokens(), (ETokenType[])objectArray)) continue;
                entityMatchesCriticalStatement = true;
                statement = StringUtils.concat((Object[])objectArray, (String)" ");
                break;
            }
            if (!entityMatchesCriticalStatement) {
                return;
            }
        } else {
            statement = subType.toUpperCase();
        }
        statement = this.buildStatementNameForEdgeCase(statement);
        this.buildFinding(this.getFindingsMessage() + MarkupUtils.formatAsSourceCode((String)statement), this.buildLocation().forEntity(entity)).createAndStore();
    }

    private String buildStatementNameForEdgeCase(String statement) {
        if (statement.contains("SYNTAX_CHECK")) {
            return statement.replace('_', '-');
        }
        return statement;
    }

    protected abstract Set<String> getStatements();

    protected abstract String getFindingsMessage();
}

