/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;

@Check(id="cqse-abap-dynamic-invocation", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DynamicInvocationCheck
extends CheckImplementationBase {
    private static final TokenTypePattern DYNAMIC_METHOD_PATTERN = new TokenTypePattern("<RPAREN><EQGT>|(<EQGT>|<ARROW>)<LPAREN>");
    private static final TokenTypePattern DYNAMIC_FUNCTION_PATTERN = new TokenTypePattern("<CALL><FUNCTION>[^<CHARACTER_LITERAL><STRING_LITERAL>]");
    private static final TokenTypePattern DYNAMIC_SUBROUTINE_PATTERN = new TokenTypePattern("<PERFORM><LPAREN>|<IN><PROGRAM><LPAREN>");
    @CheckOption(name="Flag dynamic method calls", description="Create findings for dynamic method calls.")
    private boolean flagMethodCalls = true;
    @CheckOption(name="Flag dynamic function calls", description="Create findings for dynamic function calls.")
    private boolean flagFunctionCalls = true;
    @CheckOption(name="Flag dynamic subroutine calls", description="Create findings for dynamic subroutine calls.")
    private boolean flagSubroutineCalls = true;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (this.flagMethodCalls && "call".equals(statement.getSubtype()) && DYNAMIC_METHOD_PATTERN.matcher((List)statement.ownStartTokens()).find()) {
                this.buildFinding("Dynamic method call", this.buildLocation().forEntity(statement)).createAndStore();
            }
            if (this.flagFunctionCalls && "call".equals(statement.getSubtype()) && DYNAMIC_FUNCTION_PATTERN.matcher((List)statement.ownStartTokens()).find()) {
                this.buildFinding("Dynamic function call", this.buildLocation().forEntity(statement)).createAndStore();
            }
            if (!this.flagSubroutineCalls || !"perform".equals(statement.getSubtype()) || !DYNAMIC_SUBROUTINE_PATTERN.matcher((List)statement.ownStartTokens()).find()) continue;
            this.buildFinding("Dynamic subroutine call", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }
}

