/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-name-of-returning-parameter", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NameOfReturningParameterCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Name of Returning Parameter";
    private static final Pattern HUNGARIAN_NOTATION_PREFIX = Pattern.compile("^[a-z]{1,2}_");
    @CheckOption(name="Name of Returning Parameter - Allow hungarian notation prefixes", description="If enabled, also allow names like `rv_result`.")
    private boolean allowHungarianNotationPrefixes = false;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!method.getSubtype().equals("method declaration")) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList declarationTokens = entity.includedTokens();
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences((List)declarationTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.RETURNING, ETokenType.VALUE, ETokenType.LPAREN}).iterator();
        while (iterator.hasNext()) {
            int matchIndex = (Integer)iterator.next();
            if (matchIndex + 3 >= declarationTokens.size()) continue;
            this.checkParameterName((IToken)declarationTokens.get(matchIndex + 3));
        }
    }

    private void checkParameterName(IToken parameterNameToken) {
        String name = parameterNameToken.getText().toLowerCase();
        Object expectedName = "`result`";
        if (this.allowHungarianNotationPrefixes) {
            name = HUNGARIAN_NOTATION_PREFIX.matcher(name).replaceFirst("");
            expectedName = (String)expectedName + " or `??_result`";
        }
        if (!name.equals("result")) {
            this.buildFinding("Returning parameter %s is not called %s.".formatted(MarkupUtils.formatAsSourceCode((String)parameterNameToken.getText()), expectedName), this.buildLocation().forToken(parameterNameToken)).createAndStore();
        }
    }
}

