/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="cqse-unescaped-where-like", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnescapedWhereLikeCheck
extends CheckImplementationBase {
    private static final Set<String> TARGET_SUBTYPES = Set.of("single select", "select block");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TARGET_SUBTYPES.contains(statement.getSubtype()) || !TokenStreamUtils.containsAll((List)statement.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.WHERE, ETokenType.LIKE})) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        List parts = TokenStreamUtils.split((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.LIKE});
        for (List likeClause : parts.subList(1, parts.size())) {
            if (!UnescapedWhereLikeCheck.isUnescapedNonLiteral(likeClause)) continue;
            this.buildFinding("Non-literal `LIKE` without `ESCAPE` in a `WHERE` clause", this.buildLocation().forToken((IToken)likeClause.get(0))).createAndStore();
        }
    }

    private static boolean isUnescapedNonLiteral(List<IToken> likeClause) {
        if (likeClause.isEmpty() || likeClause.get(0).getType().isLiteral()) {
            return false;
        }
        return !TokenStreamUtils.contains(likeClause, (ETokenType)ETokenType.ESCAPE);
    }
}

