/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap_cds;

import eu.cqse.check.abap_cds.AbapCdsCheckUtils;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

public class AccessControlPhase
implements IGlobalExtractionPhase<AccessControlObject, String> {
    public List<AccessControlObject> extract(ITokenElementContext fileContext) throws CheckException {
        if (!AbapCdsCheckUtils.isAbapCdsAccessControlObject(fileContext)) {
            return Collections.emptyList();
        }
        UnmodifiableList tokenList = fileContext.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        ArrayList<AccessControlObject> allImports = new ArrayList<AccessControlObject>();
        List accessControlIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokenList, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACE, ETokenType.GRANT, ETokenType.SELECT, ETokenType.ON, ETokenType.IDENTIFIER});
        Iterator iterator = accessControlIndices.iterator();
        while (iterator.hasNext()) {
            int accessControlIndex = (Integer)iterator.next();
            allImports.add(new AccessControlObject(fileContext.getUniformPath(), ((IToken)tokenList.get(accessControlIndex + 5)).getText(), ((IToken)tokenList.get(accessControlIndex)).getText()));
        }
        return allImports;
    }

    public boolean needsAccessByValue() {
        return true;
    }

    public AccessControlObject createValue(String uniformPath, String view, String objectName) {
        return new AccessControlObject(uniformPath, view, objectName);
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.ABAP_CDS);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    @IndexValueClass
    public static class AccessControlObject
    implements IExtractedValue<String> {
        private final String uniformPath;
        private final String usedView;
        private final String objectName;

        private AccessControlObject(String uniformPath, String usedView, String objectName) {
            this.uniformPath = uniformPath;
            this.usedView = usedView.toLowerCase();
            this.objectName = objectName.toLowerCase();
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.usedView;
        }

        public String getAdditionalInformation() {
            return this.objectName;
        }
    }
}

