/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap_cds;

import eu.cqse.check.abap_cds.AbapCdsCheckUtils;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-abap-cds-view-avoid-odata-publish", languages={ELanguage.ABAP, ELanguage.ABAP_CDS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidCdsViewDataPublishCheck
extends CheckImplementationBase {
    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED;
    }

    public void execute() throws CheckException {
        if (!AbapCdsCheckUtils.isAbapCdsViewDefinition((ITokenElementContext)this.context)) {
            return;
        }
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntity previousTargetAnnotation = null;
        for (ShallowEntity entity : topLevelEntities) {
            if (AvoidCdsViewDataPublishCheck.isTargetAnnotation(entity)) {
                previousTargetAnnotation = entity;
                continue;
            }
            if (AvoidCdsViewDataPublishCheck.isViewDefinition(entity)) {
                if (previousTargetAnnotation == null) continue;
                String message = "OData.publish:true annotation on CDS view" + AvoidCdsViewDataPublishCheck.determineViewNameAsMessageSuffix(entity);
                this.buildFinding(message, this.buildLocation().forEntity(previousTargetAnnotation)).createAndStore();
                continue;
            }
            if (entity.getType() != EShallowEntityType.METHOD) continue;
            previousTargetAnnotation = null;
        }
    }

    private static boolean isTargetAnnotation(ShallowEntity entity) {
        return entity.getSubtype().equals("Annotation with value") && "odata.publish".equals(entity.getName()) && ((IToken)entity.includedTokens().getLast()).getType() == ETokenType.BOOLEAN_LITERAL && ((IToken)entity.includedTokens().getLast()).getText().equals("true");
    }

    private static boolean isViewDefinition(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        return entity.getSubtype().equals("View Definition") || entity.getSubtype().equals("View Entity Definition");
    }

    private static String determineViewNameAsMessageSuffix(ShallowEntity entity) {
        String viewNameLowercased = entity.getName();
        for (IToken token : entity.ownStartTokens()) {
            if (token.getType() != ETokenType.IDENTIFIER || !token.getText().equalsIgnoreCase(viewNameLowercased)) continue;
            return " " + MarkupUtils.formatAsSourceCode((String)token.getText());
        }
        return "";
    }
}

